﻿<%@ Page Language="C#" AutoEventWireup="True" EnableViewState="true" ValidateRequest="false" EnableEventValidation="false" Inherits="ccPublisherWeb.CADWindow" Codebehind="CADWindow.aspx.cs"%>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>
<%@ Register TagPrefix="asp" Namespace="System.Web.UI" Assembly="System.Web" %>
<%@ Register Src="~/Controls/PageHeader.ascx" TagName="PageHeader" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/QnATableControl.ascx" TagName="QnATableControl" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/PreviewControl.ascx" TagName="PreviewControl" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/DisclaimerDialog.ascx" TagName="DisclaimerDialog" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>CAD</title>    

   <asp:PlaceHolder ID="Placeholder_ModifyReferrer" runat="server">
        <script language="javascript" type="text/javascript" src="js-xsa-snippet.js"></script>
    </asp:PlaceHolder>

   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="CADViewer.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ErrorPanel.css" runat="server" />

   <style type="text/css">
      /* Required for correct behavior of "onresize" event in IE */
      HTML, BODY 
      {
         height: 100%;
      }
      
      HTML, BODY, FORM
      {
         <%# (bool)ccPublisherWeb.ApplicationVars.Current["CADWindow_AutoSize"] ? "overflow: hidden;" : "overflow: inherit;" %>
      }
      
      BODY.WindowScroll
      {
         overflow: auto !important;
      }
      
      .ui-tabs
      {
         border: none !important;
      }
   </style>
</head> 
   
<body id="CADBody">
    <ccPublisherWeb:JavascriptRessource ScriptName="wz_tooltip.js" UseHandler="false" runat="server" />
    <ccPublisherWeb:JavascriptRessource ScriptName="CadWindowAccordion.js" UseHandler="false" runat="server" />
    
    <script src="<%# ccPublisherWeb.CommonFunc.GetWebResourceUrl(Page, typeof(CADWindow), "ccPublisherWeb.JS.PluginDetect.js") %>" language="javascript" type="text/javascript"></script>
    <script src="<%# ccPublisherWeb.CommonFunc.GetWebResourceUrl(Page, typeof(CADWindow), "ccPublisherWeb.JS.json_legacy.js") %>" language="javascript" type="text/javascript"></script>

    <form id="mainForm" name="mainForm" runat="server">
        <asp:ScriptManager ID="scriptManager" EnableViewState="true" runat="server" AsyncPostBackTimeout="600"/> 
        <ccPublisherWeb:JavascriptRessource ID="JavascriptRessource1" ScriptName="jquery.dropdown.js" UseHandler="false" runat="server" />
        <asp:PlaceHolder ID="Placeholder_ScriptTop" runat="server">
            <script language="javascript" type="text/javascript">
                var viewerActive = false;
                var modalTimer;

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      BeginRequestHandler                                   --%>
                <%-- Description:   Handles the beginRequest event of the                 --%>
                <%--                PageRequestManager instance.                          --%>
                <%-- -------------------------------------------------------------------- --%>
                function BeginRequestHandler(sender, args) {
                    $("#hidScrollPosition").val($('#CADBody').scrollTop());

                    if(!viewerActive) {
                        modalTimer = setTimeout(function() {
                            lockBottomPageCadViewer(true);
                            <%# ModalProgressID %>.Show();
                        }, 500);
                    }

                    <%# ccPublisherWeb.CustomApplicationHooks.Factory.CADWindow_UpdatePanelProgressStartClientScript %>
                }
         
                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      EndRequestHandler                                     --%>
                <%-- Description:   Handles the endRequest event of the                   --%>
                <%--                PageRequestManager instance.                          --%>
                <%-- -------------------------------------------------------------------- --%>
                function EndRequestHandler(sender, args) {
                    var scrollposition = $("#hidScrollPosition").val();
                    $('#CADBody').scrollTop(scrollposition);

                    var err = args.get_error();
                    if (err){
                        if (err.name == "Sys.WebForms.PageRequestManagerServerErrorException") {
                            args.set_errorHandled(true);
                        }

                       if(<%# CommonFunc.JsBool(CommonSettings.IsDebuggingEnabled) %>) {
                          <%# MessageBoxID %>.Show({
                              title      : "Error",
                              messageText: err.message,
                              width: 400,
                              height: 110,
                              focusButton: MessageBox.Constants.MB_OK,
                              icon: MessageBox.Constants.MB_ICON_ERROR,
                              buttons: MessageBox.Constants.MB_OK
                          });
                       }
                    }

                    if(modalTimer) {
                        clearTimeout(modalTimer);
                    }

                    if(!keepMiniCadViewerLock) {
                        lockBottomPageCadViewer(false);
                    }

                    <%# ModalProgressID %>.Hide();

                    autoResize();

                    autoSizeGraphicalSelection();
                    <%# ccPublisherWeb.CustomApplicationHooks.Factory.CADWindow_UpdatePanelProgressEndClientScript %>

                    ImplementXsaEvents(true);

                    <%-- Restore scroll position of QnA panel after request --%>
                    if(currentQnAScrollPosition > 0) {
                        maintainQnAScrollPosition(currentQnAScrollPosition);
                    }
                }

                var prm = Sys.WebForms.PageRequestManager.getInstance(); 
                prm.add_beginRequest(BeginRequestHandler); 
                prm.add_endRequest(EndRequestHandler); 

				<%-- Set to "true" to not unlock the left sidebar CAD viewer after EndRequest-event --%>
                var keepMiniCadViewerLock = false;

                var currentDialogSize = null;
                var dialogFirstRun = true;
            
                var dialogDefaults = {
                    width: <%# ApplicationVars.Current.GetAsSize("AppletViewer_DefaultWindowSize").Width %>,
                    height: <%# ApplicationVars.Current.GetAsSize("AppletViewer_DefaultWindowSize").Height %>,
                    left: -1,
                    top: -1,
                    scrolling: "no",
                    maximized: <%# CommonFunc.JsBool((bool)ApplicationVars.Current["AppletViewer_Maximized"]) %>,
                    dragAndMaximize: true
                };

                var dialogOptions = { };

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      prepareViewer                                         --%>
                <%-- Description:   Prepares the dialog for 2D or 3D Viewer.              --%>
                <%--                                                                      --%>
                <%-- -------------------------------------------------------------------- --%>
                function prepareViewer(title, _options) {
                    dialogOptions = $.extend({ }, dialogDefaults, _options);

                    currentDialogSize = {
                        width: Math.min(dialogOptions.width, $(window).width() - 20),
                        height: Math.min(dialogOptions.height, $(window).height() - 20)
                    };

                    $(".Dialog_AppletViewer .SizeFrame")
                        .css("width", (currentDialogSize.width - 5) + "px")
                        .css("height", (currentDialogSize.height - 5) + "px");

                    $(".Dialog_AppletViewer IFRAME").remove();
                 
                    $(".Dialog_AppletViewer .SizeFrame").append(
                        $("<iframe>")
                            .attr("id", "Dialog_AppletViewer_IFrame")
                            .attr("marginwidth", "0")
                            .attr("marginheight", "0")
                            .attr("frameborder", "0")
                            .attr("scrolling", dialogOptions.scrolling)
                            .attr("width", currentDialogSize.width - 5)
                            .attr("height", currentDialogSize.height - 5)
                    );

                    var appletViewerLoading = false;

                    $(".Dialog_AppletViewer").css("overflow", "hidden").dialog({
                        autoOpen: true,
                        modal: true,
                        closeOnEscape: true,
                        title: title,
                        width: currentDialogSize.width,
                        height: "auto",
                        minWidth: 300,
                        /*minHeight: 350,*/
                        resizable: dialogOptions.dragAndMaximize,
                        draggable: dialogOptions.dragAndMaximize,
                        autoFit: true,
                        open: function() {
                            $("body").css("overflow", "hidden");
                            appletViewerLoading = true;

                            if (!$(".Dialog_AppletViewer .DialogOverlay").length) {
                                $(".Dialog_AppletViewer").append($("#DialogOverlay").clone().removeAttr("id"));
                            }

                            setTimeout(function() {
                                if (appletViewerLoading) {
                                    $(".Dialog_AppletViewer .DialogOverlay").show();
                                }
                            }, 200);

                            $(".Dialog_AppletViewer IFRAME").bind("load", function() {
                                if (typeof($(".Dialog_AppletViewer IFRAME").attr("src")) !== "undefined") {
                                    appletViewerLoading = false;

                                    $(".Dialog_AppletViewer .DialogOverlay").hide();

                                    if(dialogOptions.maximized) {
                                        $(".Dialog_AppletViewer").dialogExtend("maximize");
                                    }
                                }
                            });

                            keepMiniCadViewerLock = true;
                        },
                        close:
                            function() {
                                $("body").css("overflow", "inherit");
                                viewerActive = false;
                                appletViewerLoading = true;
                                <%-- BEGIN - 20140508 - CAL --%>
                                <%-- We have to remove the java applet before we remove the iframe. --%>
                                <%-- This will prevent errorneous java applet handling in Internet Explorer 11. --%>
                                <%-- See http://svn.kimweb.de/cc-bt/view.php?id=1696 for details. --%>
                                <%-- Additional: This action shold not be performed in offline version because of a crash of ccWebEngine.exe --%>

                                var isOnlineVersion = <%# CommonFunc.JsBool(CommonSettings.ApplicationOnlineVersion) %>;

                                if (isOnlineVersion) {
                                    $(".Dialog_AppletViewer IFRAME").contents().find("applet").remove();
                                }
                                
                                <%-- END - 20140508 - CAL --%>
                                $(".Dialog_AppletViewer IFRAME").unbind("load");
                                $(".Dialog_AppletViewer IFRAME").remove();
                                $(".Dialog_AppletViewer .DialogOverlay").hide();

                                keepMiniCadViewerLock = false;
                                lockBottomPageCadViewer(false);

                                <%# ccPublisherWeb.CustomApplicationHooks.Factory.CADWindow_AppletViewer_OnDialogCloseScript %>

                                $(".Dialog_AppletViewer").dialog("destroy");
                            },
                        resizeStart:
                            function() {
                                $(".Dialog_AppletViewer .SizeFrame").hide();
                            },
                        dragStart:
                            function() {
                                $(".Dialog_AppletViewer .SizeFrame").hide();
                            },
                        dragStop:
                            function() {
                                $(".Dialog_AppletViewer .SizeFrame").show();

                                if ($(".Dialog_AppletViewer").dialogExtend("state") != "maximized") {
                                    dialogDefaults.left = $(".Dialog_AppletViewer").parents(".ui-dialog").eq(0).position().left;
                                    dialogDefaults.top = $(".Dialog_AppletViewer").parents(".ui-dialog").eq(0).position().top;
                                }
                            },
                        resizeStop:
                            function() {
                                appletResize(true);
                            },
                        onAutoFit:
                            function() {
                                if ($(".Dialog_AppletViewer").dialogExtend("state") != "maximized") {
                                    dialogDefaults.left = $(".Dialog_AppletViewer").parents(".ui-dialog").eq(0).position().left;
                                    dialogDefaults.top = $(".Dialog_AppletViewer").parents(".ui-dialog").eq(0).position().top;
                                    appletResize(true);
                                }
                            }
                    });

                    if(dialogOptions.dragAndMaximize) {
                        $(".Dialog_AppletViewer").dialogExtend({
                            maximize: true,
                            dblclick: "maximize",
                            strings: {
                                buttonClose: "<%# ccPublisherWeb.TextDic.TxGet("AppletViewer_ButtonClose") %>",
                                buttonMaximize: "<%# ccPublisherWeb.TextDic.TxGet("AppletViewer_ButtonMaximize") %>",
                                buttonRestore: "<%# ccPublisherWeb.TextDic.TxGet("AppletViewer_ButtonRestore") %>"
                            },
                            events : {
                                maximize:
                                    function() {
                                        dialogDefaults.maximized = true;
                                        appletResize(false);
                                    },
                                restore:
                                    function() {
                                        dialogDefaults.maximized = false;
                                        appletResize(true);
                                    }
                            }
                        });

                        if(dialogOptions.left > -1 || dialogOptions.top > -1) {
                            $(".Dialog_AppletViewer").parents(".ui-dialog").eq(0).css("left", dialogOptions.left + "px").css("top", dialogOptions.top + "px");
                        }

                        if(dialogDefaults.maximized) {
                            $(".Dialog_AppletViewer").dialogExtend("maximize");
                        } else {
                            $(".Dialog_AppletViewer").dialog("autorepos");
                        }
                    }//if(dialogOptions.dragAndMaximize)

                    lockBottomPageCadViewer(true);
                    dialogFirstRun = false;
                    viewerActive = true;
                }//prepareViewer

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      prepareSectionalView                                  --%>
                <%-- Description:   Preapre 2D viewer for sectional view.                 --%>
                <%--                                                                      --%>
                <%-- -------------------------------------------------------------------- --%>
                function prepareSectionalView() {
                   prepareViewer("<%# TextDic.TxGet("Text_Ansicht2DVorschau") %>");
                }//prepareSectionalView
                
                function appletResize(saveOptions) {
                    $(".Dialog_AppletViewer").dialog("_size");

                    var width  = $(".Dialog_AppletViewer").width() - 5;
                    var height = $(".Dialog_AppletViewer").height() - 5;

                    if(saveOptions) {
                        dialogDefaults.width  = width;
                        dialogDefaults.height = height;
                    }

                    $(".Dialog_AppletViewer IFRAME").attr("width", width).attr("height", height);
                    $(".Dialog_AppletViewer .SizeFrame").css("width", width + "px").css("height", height + "px").show();

                    try {
                        document.getElementById("Dialog_AppletViewer_IFrame").contentWindow.setSize(width, height);
                    } catch(e) { /* ignore */ }
                }//appletResize

                function showClick2CADDialog() {
                    viewerActive = true;

                    $(".Dialog_Click2CAD").dialog({
                        autoOpen: true,
                        modal: true,
                        closeOnEscape: true,
                        title: "<%# ccPublisherWeb.TextDic.TxGet("Text_Click2CADLegend") %>",
                        width: 500,
                        height: 195,
                        resizable: JS_GLOBALS.jqDialogsResizable,
                        draggable: JS_GLOBALS.jqDialogsDraggable,
                        open: function() {
                            setTimeout(function() {
                              $("body").css("overflow", "hidden");
                            }, 200);

                            $(".Dialog_Click2CAD IFRAME").attr("src", $("#<%# hdClick2CAD_URL.ClientID %>").val());
                        },
                        close: function() {
                            $("body").css("overflow", "inherit");
                            $(".Dialog_Click2CAD IFRAME").attr("src", "");
                            viewerActive = false;
                            keepMiniCadViewerLock = false;
                            lockBottomPageCadViewer(false);
                        }
                    });

                    lockBottomPageCadViewer(true);
                }//showClick2CADDialog

                function hideClick2CADDialog() {
                    $(".Dialog_Click2CAD").dialog("close");
                }//hideClick2CADDialog

                function hideAppletViewer() {
                    $(".Dialog_AppletViewer").dialog("close");
                }

                function openJavaHelpWindow() {
                    prepareViewer("<%# ccPublisherWeb.TextDic.TxGet("CADViewer_JavaTest") %>", {
                        scrolling: "auto",
                        dragAndMaximize: false,
                        width: <%# ApplicationVars.Current.GetAsSize("AppletViewer_DefaultWindowSize").Width %>,
                        height: <%# ApplicationVars.Current.GetAsSize("AppletViewer_DefaultWindowSize").Height %>,
                        left: -1,
                        top: -1,
                        maximized : false,                       
                    });
           
                    if(viewerActive) {
                        $(".Dialog_AppletViewer IFRAME").attr("src", "<%# ResolveUrl("~/JavaApplets/Help/help.aspx") %>");
                    }
                }//openJavaHelpWindow

               function configLoad() {
                  prepareViewer("<%# ccPublisherWeb.TextDic.TxGet("Text_Kload") %>", {
                     scrolling: "auto",
                     dragAndMaximize: false,
                     width: <%# ApplicationVars.Current.GetAsSize("AppletViewer_DefaultWindowSize").Width %>,
                     height: 190,
                     left: -1,
                     top: -1,
                     maximized : false,                       
                  });
           
                  if(viewerActive) {
                     $(".Dialog_AppletViewer IFRAME").attr("src", "<%# ResolveUrl("~/ConfigUpload.aspx") %>");
                  }
               }
         
                function startDimDrawPDFExt() {
                    <%# Page.ClientScript.GetPostBackEventReference(ButtonDimDrawPDF, "") %>
                }//startDimDrawPDFExt
         
                function showCadDownload() {
                    $(".Popup_CADDownload").dialog({
                        autoOpen: true,
                        modal: true,
                        closeOnEscape: true,
                        title: "<%# ccPublisherWeb.TextDic.TxGet("Text_Download") %>",
                        height: "auto",
                        width: 500,
                        minHeight: 70,
                        resizable: JS_GLOBALS.jqDialogsResizable,
                        draggable: JS_GLOBALS.jqDialogsDraggable,
                        open:
                            function() {
                                keepMiniCadViewerLock = true;
                                $("#btDownloadDlgClose").focus();
                            },
                        close:
                            function() {
                                keepMiniCadViewerLock = false;
                                lockBottomPageCadViewer(false);
                                <%# ccPublisherWeb.CustomApplicationHooks.Factory.CADWindow_DownloadMessage_OnDialogCloseScript %>
                            }
                    });

                    lockBottomPageCadViewer(true);

                    <%-- Move the dialog back to the main form so that all hidden fields can be successfully transferred --%>
                    $(".Popup_CADDownload").parent().appendTo($("#<%# mainForm.ID %>"));
                }//showCadDownload

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      SetActiveTab                                          --%>
                <%-- Description:   Selects the active tab from the export tab panel.     --%>
                <%-- Parameters:                                                          --%>
                <%--    tabid     : the id of the tab which we want to select.            --%>
                <%-- -------------------------------------------------------------------- --%>
                function SetActiveTab(tabid) {
                    //alert('select tab ' + tabid);
                    $("#Tabs").tabs("select", '#' + tabid);
                }

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      getCurrentConfiguration                               --%>
                <%-- Description:   Returns the current configuration.                    --%>
                <%-- Parameters:                                                          --%>
                <%--    answerList: complete configuration string                         --%>
                <%--    pgid      : product group ID of the current article               --%>
                <%--    cadPar    : CAD-Parameter                                         --%>
                <%-- -------------------------------------------------------------------- --%>
                function getCurrentConfiguration() {
                    return {
                        answerList: $("#<%# CurrentAnswersList.ClientID %>").val(),
                        pgid        : $("#pgid").length ? $("#pgid").val() : "",
                        articleID   : $("#ArtikelNr").length ? $("#ArtikelNr").val() : "",
                        cadPar      : $("#<%# StartCadPar.ClientID %>").length ? $("#<%# StartCadPar.ClientID %>").val() : "",
                        cadPath     : $("#cadPath").length ? $("#cadPath").val() : "",
                        artGroup    : $("#ArtGroup").length ? $("#ArtGroup").val() : ""
                    };
                }

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      gotoRegForm                                           --%>
                <%-- Description:   Handles, which reg form is shown, if the user is not  --%>
                <%--                registered and wants to do a click2cad output.        --%>
                <%-- -------------------------------------------------------------------- --%>
                function gotoRegForm() {
                    setTimeout(function() {
                        <%# ModalProgressID %>.Show();
                        window.location.href = "<%# String.IsNullOrEmpty(CommonSettings.SessionSettings.ExtLogInURL) ? ResolveUrl("~/UserLogin.aspx") : CommonSettings.SessionSettings.ExtLogInURL %>";
                    },0);
                }//gotoRegForm

                function lockBottomPageCadViewer(lock) {
                    try {
                        if(parent && parent.Leer) {
                            parent.Leer.lockCadViewerToolbar(lock);
                        }
                    } catch(e) { }
                }//lockBottomPageCadViewer
            
                $(window).resize(function() {
                    autoResize();
                });

                var currentQnAScrollPosition = 0;

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      maintainQnAScrollPosition                             --%>
                <%-- Description:   Maintain scroll position of QnA panel                 --%>
                <%--                Call with no arguments to store the current position, --%>
                <%--                otherwise set the desired scroll position as first    --%>
                <%--                argument.                                             --%>
                <%-- -------------------------------------------------------------------- --%>
                function maintainQnAScrollPosition(newPosition) {
                    if(arguments.length > 0) {
                        currentQnAScrollPosition = $("#QnAPanel").scrollTop(newPosition);
                    } else {
                        currentQnAScrollPosition = $("#QnAPanel").scrollTop();
                    }
                }//maintainQnAScrollPosition

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      autoResize                                            --%>
                <%-- Description:   Auto reorganizes the page layout so that the preview  --%>
                <%--                area is always fixed and only the QnA area is         --%>
                <%--                scrolling.                                            --%>
                <%-- -------------------------------------------------------------------- --%>
                function autoResize() {
                    <asp:PlaceHolder ID="PlaceHolder_AutoResize" runat="server">
                        var winWidth = $(window).width();
                        var winHeight = $(window).height();

                        var pageHeaderHeight    = $("#<%# PageHeader1.ClientID %>").length ? $("#<%# PageHeader1.ClientID %>").outerHeight(true) : 0;
                        var articleHeaderHeight = $("#CADWindow #ArticleInfoHeader").length ? $("#CADWindow #ArticleInfoHeader").outerHeight(true) : 0;
                        var rubrHeaderHeight    = $("#AccCADViewer H3.CADRubrikHeader").length ? $("#AccCADViewer H3.CADRubrikHeader").outerHeight() : 0;
                        var rubrCADWindow       = ($("#Rubrik_CADWindow").length && $("#Rubrik_CADWindow").css("display") != "none") ? $("#Rubrik_CADWindow").outerHeight() : 0;
                        var innerMargin         = $("#CADWindow .InnerBorder").padding("height") + $("#CADWindow .InnerBorder").margin("height");
                        var topToolbarHeight    = $("#TopToolbar").length ? $("#TopToolbar").outHeight(true) : 0;

                        if("<%# (bool)ApplicationVars.Current["MaintainQnaContainerSize"] %>" != "<%# bool.TrueString %>") {
                            var qnaNewHeight = winHeight - pageHeaderHeight - topToolbarHeight - articleHeaderHeight - rubrHeaderHeight - rubrCADWindow - innerMargin - 5

                            <%-- When calculated QnA panel size becomes too small change scrolling to complete window --%>
                            if(qnaNewHeight > 70) {
                               $("BODY").removeClass("WindowScroll");
                               $("#QnAPanel").height(qnaNewHeight);
                            } else {
                               $("BODY").addClass("WindowScroll");
                               $("#QnAPanel").css("height", "");
                            }
                        }
                   </asp:PlaceHolder>
                }//autoResize

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      ImplementXsaEvents                                    --%>
                <%-- Description:   This function implements some events, which can be    --%>
                <%--                used by cross site scripts for event handling.        --%>
                <%-- -------------------------------------------------------------------- --%>
                function ImplementXsaEvents(fromPageRequestManager)
                {
                    var previewimage        = $('#Prev3DImg');
                    var tabpanelcontainer   = $('#TabPanel #Tabs');

                    <%-- change of the preview image --%>
                    if(previewimage.length)
                    {
                        previewimage.bind('load change', function() {
                            try {
                                if (typeof parent.jQuery != 'undefined')
                                {
                                    <%-- only, if jquery is defined in parent document --%>
                                    parent.$('body').trigger('preview_changed');
                                }    
                            } catch(e) {
                                //ignore
                            } 
                        });
                    }

                    if(!fromPageRequestManager)
                    {
                        <%-- change of the tab panel image --%>
                        if(tabpanelcontainer.length)
                        {
                            tabpanelcontainer.bind('tabsload tabsshow', function() {
                                try {
                                    if (typeof parent.jQuery != 'undefined')
                                    {
                                        <%-- only, if jquery is defined in parent document --%>
                                        parent.$('body').trigger('tabcontent_changed');
                                    }
                                } catch(e) {
                                    //ignore
                                }
                            });
                        }
                    }
                }//ImplementXsaEvents
            
                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      ShowClick2CadLabelsAndDisableControls                 --%>
                <%-- Description:   This function sets a warning label and disables       --%>
                <%--                some controls. Hides label if parameter is null.      --%>
                <%-- -------------------------------------------------------------------- --%>
                function ShowClick2CadLabelsAndDisableControls(message) {
                    if (message == null) {
                        // hide label
                        $('#<%# LBL_CLICK2CAD_2D.ClientID %>').hide();
                        $('#<%# LBL_CLICK2CAD_3D.ClientID %>').hide();
                    } else {
                        // show label
                        $('#<%# LBL_CLICK2CAD_2D.ClientID %>').show();
                        $('#<%# LBL_CLICK2CAD_3D.ClientID %>').show();
                        // set label                        
                        $('#<%= LBL_CLICK2CAD_2D.ClientID %>').html(message);
                        $('#<%= LBL_CLICK2CAD_3D.ClientID %>').html(message);

                        // disable controls and set cursor style not allowed
                        var controlArray = new Array('#click2cadformat_2D', '#DropDownListC2C2DAnsichten', '#BTN_CLICK2CAD_2D', '#click2cadformat_3D', '#BTN_CLICK2CAD_3D');

                        for (i = 0; i < controlArray.length; i++) {
                            $(controlArray[i]).attr('disabled', 'disabled');
                            $(controlArray[i]).attr('style', 'cursor:not-allowed');
                        }
                    }
                }//ShowClick2CadLabelsAndDisableControls
                
                var JavaTestAppletTrials=0;
                <%-- how much times we are waiting for (IE)-Java-Response (n*200ms) --%>
                var JavaTestAppletMaxTrials=100; 
                var JavaTestAppletTimer=null;
                var JavaTestAppletDetected=false;
                function JavaTestAppletCheckTimer() {
                    if (JavaTestAppletDetected && JavaTestAppletTimer != null) {
                        window.clearTimeout(JavaTestAppletTimer);
                    } else {
                        JavaTestAppletTrials++;
                        if (JavaTestAppletTrials >= JavaTestAppletMaxTrials) {
                            window.clearTimeout(JavaTestAppletTimer);
                            ShowClick2CadLabelsAndDisableControls("<%# TextDic.TxGet("Text_ErrorJavaNotInstalledOrNotEnabled") %>"); 
                            ccPublisherWeb.SetSessionVariable("JavaState",1);
                        }
                    }
                }//JavaTestAppletCheckTimer
                
                function TestAppletLoaded(respObjString) {
                    JavaTestAppletDetected=true;
                }//IETestAppletLoaded

                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      ValidateJavaVersionAndOs                              --%>
                <%-- Description:   This function verifies OS and Java-Installation.      --%>
                <%--                Shows a warning-label and disables controls if needed.--%>
                <%-- -------------------------------------------------------------------- --%>
                function ValidateJavaVersionAndOs() {
                    //NotChecked = 0,
                    //Disabled = 1,
                    //EnabledWindows = 2,
                    //EnabledNonWindows = 3

                    // check  already performed?
                    var checkstate = ccPublisherWeb.GetSessionVariable("JavaState");
                    if (checkstate != 0) return;

                    // verify running under Windows
                    var isWindows = navigator.userAgent.toLowerCase().indexOf("windows") >= 0;

                    // verify java with Plugindetect
                    var status = parseFloat(PluginDetect.isMinVersion('Java', JS_GLOBALS.minJavaVersion));
                    var isJavaReady = (status == 1);
                    if (!isWindows) {
                        ShowClick2CadLabelsAndDisableControls("Only works under Windows");
                        if (isJavaReady) ccPublisherWeb.SetSessionVariable('JavaState',3);
                        else ccPublisherWeb.SetSessionVariable('JavaState',1);
                        return;
                    }
                    if (!isJavaReady) {
                        if (status <= -1)
                            ShowClick2CadLabelsAndDisableControls("<%# TextDic.TxGet("Text_ErrorJavaNotInstalled") %>");
                        else ShowClick2CadLabelsAndDisableControls("<%# TextDic.TxGet("Text_ErrorJavaNotEnabled") %>");
                        ccPublisherWeb.SetSessionVariable("JavaState",1);
                        return;
                    }


                    // verify if java is disabled in control center
                    if (ccPublisherWeb.GetSessionVariable("JavaTestAppletChecked") != 1) {
                        ccPublisherWeb.SetSessionVariable("JavaTestAppletChecked", 1);
                        JavaTestAppletTimer = window.setInterval('JavaTestAppletCheckTimer()', 200);
                    }

                    // hide labels
                    ccPublisherWeb.SetSessionVariable("JavaState",2);
                    ShowClick2CadLabelsAndDisableControls(null);
                }//validateJavaVersionAndOs
                
                function ShowExportPanel()
                {
                    if($("#AccCADViewer H3.CADRubrikHeader").length) {
                        var opened = $("#AccCADViewer H3.CADRubrikHeader").hasClass('ui-accordion-header-active');
                        if (!opened) {
                            $("#AccCADViewer H3.CADRubrikHeader").click();
                        }
                       $(window).scrollTop(0);
                    }
                }
                
                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      startDownload                                         --%>
                <%-- Description:   Starts the download of the given target file.         --%>
                <%-- -------------------------------------------------------------------- --%>
                function startDownload(sender, target, multiplefiles) {
                    var dochecklogin = <%# CommonSettings.DoCheckLoginNeededAndRedirect ? "true" : "false" %>;
                    var showreghints = <%# ShowRegistrationHints ? "true" : "false" %>;
                    var cadboxdisabled = <%# CommonSettings.SessionSettings.CADBox == CadBoxModes.Disabled ? "true" : "false" %>;

                    var isclick2Cad = sender.id == "btnclick2cad2d" || sender.id == "btnclick2cad3d";

                    var isdownloaddisabled =
                        isclick2Cad && (dochecklogin && (showreghints && cadboxdisabled)) ||
                        isclick2Cad && showreghints ||
                        !isclick2Cad && (<%# RegisterLoginLimit == RegisterLoginLimits.FileCreation ? "true" : "false" %> && (dochecklogin && (showreghints && cadboxdisabled))) ||
                        !isclick2Cad && (<%# RegisterLoginLimit == RegisterLoginLimits.FileCreation ? "true" : "false" %> && showreghints);
                        

                    if (isdownloaddisabled) {
                        if (isclick2Cad) {
                            <%# GetRegnoteScript(RegnoteScriptType.Click2CAD) %>
                        } else {
                            <%# GetRegnoteScript(RegnoteScriptType.CadDownload) %>
                        }
                        return;
                    }

                    var isPreprocessing = <%# Convert.ToString(!string.IsNullOrEmpty(FileGenerationPreprocessingScript)).ToLower() %>;
                    
                    if (isPreprocessing) {
                        <%# FileGenerationPreprocessingScript %>
                    } else {
                        exceuteDownloadTask(sender, target, multiplefiles);
                    }
                }                    


                <%-- -------------------------------------------------------------------- --%>
                <%-- Function:      exceuteDownloadTask                                         --%>
                <%-- Description:   Starts the download of the given target file.         --%>
                <%-- -------------------------------------------------------------------- --%>
                function exceuteDownloadTask(sender, target, multiplefiles) {
                    <%-- ReSharper disable UseOfImplicitGlobalInFunctionScope --%>

                    if (sender == undefined) {
                        alert('startDownload: No sender given!');
                        return false;
                    }
                    
                    var showdisclaimerdialog = '<%# Convert.ToString(ShowDisclaimerDialog && (CadBoxMode != CadBoxModes.Disabled))  %>' == 'True' ? true : false;

                    if (showdisclaimerdialog) {
                        switch(sender.id) {
                            case "btnclick2cad2d":
                                showDisclaimerDialog('CLICK2CAD_2D');
                                break;
                            case "btnclick2cad3d":
                                showDisclaimerDialog('CLICK2CAD_3D');
                                break;
                            case "btncaddownload2d":
                                __doPostBack('BTN_CAD_DOWNLOAD_2D');
                                break;
                            case "btncaddownload3d":
                                __doPostBack('BTN_CAD_DOWNLOAD_3D');
                            default:
                                showDisclaimerDialog(target, multiplefiles);
                                break;
                        }
                    } else {
                        switch(sender.id) {
                            case "btnclick2cad2d":
                                __doPostBack('BTN_CLICK2CAD_2D');
                                break;
                            case "btnclick2cad3d":
                                __doPostBack('BTN_CLICK2CAD_3D');
                                break;
                            case "btncaddownload2d":
                                __doPostBack('BTN_CAD_DOWNLOAD_2D');
                                break;
                            case "btncaddownload3d":
                                __doPostBack('BTN_CAD_DOWNLOAD_3D');
                                break;
                            default:
                                if(target != ''){
                                    window.location = target;
                                }
                                break;
                        }
                    }

                    return true;
                    <%-- ReSharper restore UseOfImplicitGlobalInFunctionScope --%>
                }//exceuteDownloadTask
                
                $(document).ready(function () {
                    <%# ccPublisherWeb.CustomApplicationHooks.Factory.CADWindow_PageLoadClientScript %>

                    $("#Tabs").tabs({
                        select: function(event, ui) { ccPublisherWeb.SetSessionVariable("ActiveTabPanelID", ui.panel.id); }
                    });

                    SetActiveTab("<%# CommonSettings.SessionSettings.ActiveTabPanel %>");
		      
                    if("<%# (bool)ApplicationVars.Current["TabChangeAnimation"] %>" == "<%# bool.TrueString %>") {
                        $("#Tabs").tabs("option", "fx", { opacity: "toggle", duration: "fast" });
                    }

                    $("#Tabs").css("display", "block"); 

                    autoSizeGraphicalSelection();

                    <asp:PlaceHolder ID="Placeholder_UpdateDownloadAndSearch" runat="server">
                        try {
                            if(parent.Oben) {
                                parent.Oben.location.href = parent.Oben.location.href;
                            }
                        } catch(e) {}
                    </asp:PlaceHolder>

                    if($("#AccCADViewer H3.CADRubrikHeader").length) {
                        new CadWindowAccordion({
                            ClientID: "AccCADViewer",
                            OCHelperClientID: "<%# opencategories.ClientID %>",
                            expandAll: false,
                            expandTitle: "<%# TextDic.TxGet("Text_Accordion_Expand") %>",
                            collapseTitle: "<%# TextDic.TxGet("Text_Accordion_Collapse") %>",
                            collapseAll: <%# (bool)ApplicationVars.Current["CollapseCadWindow"] ? "true" : "false"%>,
                            click:
                                function() {
                                    autoResize();
                                    maintainQnAScrollPosition();
                                }
                        });
                    }

                    if($("#<%# TestApplet_Panel.ClientID %>").length) {
                        ValidateJavaVersionAndOs();
                    }

                    <%-- Handlers for the top toolbar. Do the jQueryUI styling and handle click events --%>
                    if($("#TopToolbar").length) {
                       $("#TopToolbar BUTTON").mouseover(function() {
                          if(!$(this).hasClass("ui-state-disabled")) {
                             $(this).addClass("ui-state-hover");
                          }
                       }).mouseout(function() {
                          $(this).removeClass("ui-state-hover ui-state-active");
                       }).mousedown(function() {
                          if(!$(this).hasClass("ui-state-disabled")) {
                             $(this).addClass("ui-state-active");
                          }
                       }).mouseup(function() {
                          $(this).removeClass("ui-state-active");
                       }).click(function() {
                          switch($(this).attr("id")) {
                             case "btConfigPrint":
                                break;

                             case "btConfigSave":
                                js_FormSend("ConfigSave.aspx", "Leer", "POST");
                                break;

                             case "btConfigLoad":
                                configLoad();
                                break;

                             case "btConfigReset":
                                <%# MessageBoxID %>.Show({
                                   title: "<%# TextDic.TxGet("Text_ConfigReset_Title") %>",
                                   messageText: "<%# TextDic.TxGet("Text_ConfigReset_Question") %>",
                                   width: 400,
                                   height: 110,
                                   focusButton: MessageBox.Constants.MB_NO,
                                   icon: MessageBox.Constants.MB_ICON_QUESTION,
                                   buttons: MessageBox.Constants.MB_YES | MessageBox.Constants.MB_NO,
                                   onYes: function(sender) {
                                      <%# ccPublisherWeb.CustomApplicationHooks.Factory.CADWindow_BeforeConfigurationResetScript %>;

                                      var currentConfig = getCurrentConfiguration();

                                      setTimeout(function() {
                                         window.location.href =
                                            "ccHandler.aspx" +
                                            "?cadPath=" + currentConfig.cadPath +
                                            "&pgid=" + currentConfig.pgid +
                                            "&ArtikelNr=" + currentConfig.articleID +
                                            "&FROM=" + currentConfig.artGroup +
                                            "&CADReload=true";
                                      }, 0);
                                   }
                                });
                                break;
                          }
                       });
                    }

                    autoResize();

					<%-- Track current QnA panel scroll position for a later restore after each request --%>
                    $("#QnAPanel").scroll(function() { maintainQnAScrollPosition(); });

					<%-- Bind XSA events to window object. --%>
                    ImplementXsaEvents(false);
                });
            </script>
        </asp:PlaceHolder>
    
    
      <asp:PlaceHolder ID="Placeholder_Main" runat="server">
         <ccPublisherWeb:PageHeader ID="PageHeader1" CssClass="PageHeader" runat="server" />

         <asp:PlaceHolder ID="Placeholder_TopToolbar" runat="server">
            <div id="TopToolbar" class="ui-widget-header ui-corner-all">
               <button id="btConfigPrint" class="ui-widget ui-corner-all ui-state-default " type="button" style="display: none"><span>Drucken</span></button>
               <button id="btConfigSave" class="ui-widget ui-corner-all ui-state-default" type="button"><span><%# TextDic.TxGet("TextSaveKCO") %></span></button>
               <button id="btConfigLoad" class="ui-widget ui-corner-all ui-state-default" type="button"><span><%# TextDic.TxGet("Text_LadenKCO") %></span></button>
               <button id="btConfigReset" class="ui-widget ui-corner-all ui-state-default" type="button"><span><%# TextDic.TxGet("Text_ConfigReset_Title") %></span></button>
            </div>
         </asp:PlaceHolder>

         <asp:PlaceHolder ID="PLH_DIMENSIONS_SWITCH" runat="server">
            <div class="Dimensions_Switch">
                <asp:Button ID="BTN_LoadCC3File" Visible="false" Enabled="false" OnClientClick="Change_ccFileType('cc3')" runat="server" Text="Loadcc3" />
                <asp:Button ID="BTN_LoadCC2File" Visible="false" Enabled="false" OnClientClick="Change_ccFileType('cc2')" runat="server" Text="Loadcc2" />
            </div>
         </asp:PlaceHolder>

        <asp:PlaceHolder ID="PlaceHolder_Quicklink" runat="server">

        </asp:PlaceHolder>

         <div id="CADWindow">
            <div class="InnerBorder">
               <asp:PlaceHolder ID="Placeholder_ArticleInfoHeader" runat="server">
                  <div id="ArticleInfoHeader">
                     <asp:Literal ID="litArticleInfoHeader" runat="server" />
                  </div>
               </asp:PlaceHolder>
               
               <asp:Panel ID="pnlBackButton" runat="server">
                    <a href="javascript:history.go(-3);"><%# ccPublisherWeb.TextDic.TxGet("CADWindowBackButton") %></a>
               </asp:Panel>

               <div id="AccCADViewer">
                   <asp:HiddenField ID="opencategories" runat="server" Value="" />
                   
                  <asp:PlaceHolder ID="Placeholder_CADRubrikHeader" runat="server">
                     <h3 class="CADRubrikHeader"><a><%# ccPublisherWeb.TextDic.TxGet("Text_ccRubrikCADVorschauAusgabe") %></a></h3>
                  </asp:PlaceHolder>
            
                  <div id="Rubrik_CADWindow" style="display:<%# CommonFunc.BoolConvert(CommonFunc.GetParameter("CADRubrikHeaderOpened") ?? bool.TrueString) ? "block" : "none" %>">
                     <ccPublisherWeb:PreviewControl ID="PreviewWindow" runat="server"></ccPublisherWeb:PreviewControl>

                     <asp:Panel ID="TestApplet_Panel" style="line-height: 0; visibility:hidden;" runat="server">
                        <applet code="org.kim.cadclick.javadetectie.JavaDetectIE" archive="./JavaApplets/Help/javadetectie.jar?v=<%# ccPublisherWeb.VersionInfo.VersionUID %>" width="1" height="1" mayscript="mayscript" name="CADClick Test Applet IE (www.cadclick.com)">
                            <param name="backgroundColor" value="#FFFFFF" />
                            <param name="foregroundColor" value="#000000" />
                            <param name="clientSuccessScript" value="TestAppletLoaded" />
                        </applet>
                     </asp:Panel>

                     <div id="TabPanel">
                        <div id="Tabs" style="display: none">
                           <ul>
                              <li id="Tab_TabPanelCAD_3D" runat="server"><a href="#TabPanelCAD_3D"><div class="DLeft"><div class="DRight"><div class="DCenter"><span><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiter3DAusgabe") %></span></div></div></div></a></li>
                              <li id="Tab_TabPanelCAD_2D" runat="server"><a href="#TabPanelCAD_2D"><div class="DLeft"><div class="DRight"><div class="DCenter"><span><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiter2DAusgabe") %></span></div></div></div></a></li>
                              <li id="Tab_TabPanelCAD_DimDraw" runat="server"><a href="#TabPanelCAD_DimDraw"><div class="DLeft"><div class="DRight"><div class="DCenter"><span><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiterDimDraw") %></span></div></div></div></a></li>
                              <li id="Tab_TabPanelCAD_Attrib" runat="server"><a href="#TabPanelCAD_Attrib"><div class="DLeft"><div class="DRight"><div class="DCenter"><span><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiterAttribute") %></span></div></div></div></a></li>
                              <li id="Tab_TabPanelCAD_PDF3D" runat="server"><a href="#TabPanelCAD_PDF3D"><div class="DLeft"><div class="DRight"><div class="DCenter"><span><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiterPDF3D") %></span></div></div></div></a></li>
                              <li id="Tab_TabPanelUserTab0" runat="server"><a href="#TabPanelUserTab0"><div class="DLeft"><div class="DRight"><div class="DCenter"><span><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiterUserTab0") %></span></div></div></div></a></li>
                           </ul>

                           <asp:PlaceHolder ID="Placeholder_TabPanelCAD_Common" runat="server">
                              <div id="TabPanelCAD_Common">
                                   <asp:PlaceHolder ID="TabPanelCAD_Common_PreviewSettings" runat="server">
                                   </asp:PlaceHolder>
                              </div>
                           </asp:PlaceHolder>
                     
                           <asp:PlaceHolder ID="Placeholder_TabPanelCAD_3D" runat="server">
                              <div id="TabPanelCAD_3D">
                                 <fieldset>
                                    <legend><%# ccPublisherWeb.TextDic.TxGet("Text_CADFormatLegend") %></legend>

                                    <div class="CadFormatSelector">
                                       <span><%# ccPublisherWeb.TextDic.TxGet("Text_ccCADFormat") %></span>
                                       <select id="outputformat_3d" name="outputformat_3d" onchange="SelectDriverHandler(this, '3D', false);"></select>

                                       <%-- 
                                          Prepared for CAD format option list:

                                          <a class="ToggleCadFormatOptions ui-widget ui-corner-all ui-state-default" title="!!!!! CAD Formatoptionen einblenden"><span></span></a>
                                          <div class="OptionList ui-widget-content ui-corner-all" style="display: none">
                                             <h4 class="ui-widget-header ui-corner-all">Formatoptionen</h4>
                                             <div class="Content"></div>
                                          </div>
                                       --%>
    
                                       <%-- 
                                          Prepared for CAD format option list:

                                          <script type="text/javascript">
                                             $(".ToggleCadFormatOptions").mouseover(function() {
                                                $(this).addClass("ui-state-hover");
                                             }).mouseout(function() {
                                                $(this).removeClass("ui-state-hover ui-state-active");
                                             }).click(function() {
                                                var optionList = $(this).next(".OptionList:first");

                                                if(optionList.is(":visible")) {
                                                   optionList.hide();
                                                   $(this).removeClass("ui-state-active");
                                                } else {
                                                   optionList.show();
                                                   optionList.css("bottom", -optionList.outerHeight() + "px");
                                                   $(this).addClass("ui-state-active");
                                                }
                                             });
                                          </script>
                                       --%>
                                    
                                       <select id="outputoptions_3d" name="outputoptions_3d" style="display:none;"></select>
                                          
                                       <asp:CheckBox ID="CB_OPTIMIZED_FOR_UGS" Visible="false" runat="server" />
                                    
                                        <button type="button" id="btncaddownload3d" disabled="disabled" onclick="startDownload(this, null);"><%# TextDic.TxGet("Text_ccDateiGenerieren") %></button>

                                        <div style="display:none;">
                                            <asp:Button ID="BTN_CAD_DOWNLOAD_3D" runat="server" OnClick="CadDownload_3D" EnableViewState="false" Text="Generieren" />
                                        </div>
                                    </div>
                                 </fieldset>
                        
                                 <asp:PlaceHolder ID="Placeholder_DirectInsert3DEnabled" runat="server">
                                    <div class="FieldsetSpacer"></div>

                                    <fieldset>
                                       <legend><%# ccPublisherWeb.TextDic.TxGet("Text_Click2CADLegend") %></legend>

                                       <span><%#ccPublisherWeb.TextDic.TxGet("Text_ccCADSystem") %></span>

                                        <select id="click2cadformat_3d" name="click2cadformat_3d" onchange="SelectDriverHandler(this, '3D', true);"></select>
                                        
                                        <button type="button" id="btnclick2cad3d" disabled="disabled" onclick="startDownload(this, null);"><%# TextDic.TxGet("Text_ccClick2CAD") %></button>

                                        <div style="display:none;">
                                            <asp:Button ID="BTN_CLICK2CAD_3D" OnClick="Click2CADInsert_3D" Enabled="false" EnableViewState="False" runat="server" />
                                        </div>
                                        <asp:PlaceHolder ID="PH_CLICK2CAD_3D" runat="server"></asp:PlaceHolder>
                           
                                        <a href="javascript:;" class="Click2CadHelpButton" onclick="openJavaHelpWindow()" title="<%#ccPublisherWeb.TextDic.TxGet("CADViewer_JavaTest") %>">&nbsp;</a>
                                        <div><asp:Label ID="LBL_CLICK2CAD_3D" runat="server" ForeColor="red"></asp:Label></div>
                                    </fieldset>
                                 </asp:PlaceHolder>
                              </div>
                           </asp:PlaceHolder>
                  
                           <asp:PlaceHolder ID="Placeholder_TabPanelCAD_2D" runat="server">
                              <div id="TabPanelCAD_2D">
                                 <asp:PlaceHolder ID="PlaceHolder_2DExtras" runat="server">
                                 <div id="TabPanelCAD_2D_2DViewer_Extras">
                                    <fieldset>
                                       <legend><%# ccPublisherWeb.TextDic.TxGet("Text_Extras") %></legend>
                                       <asp:CheckBox ID="SHOW_HIDDENLINE" Checked="false" Text="Verdeckte Linien anzeigen?" runat="server" />
                                    </fieldset>                           
                                    <div class="FieldsetSpacer"></div>
                                 </div>
                                 </asp:PlaceHolder>
                                 <asp:PlaceHolder ID="Placeholder_BatchGen" runat="server">
                                    <fieldset>
                                       <legend><%# ccPublisherWeb.TextDic.TxGet("Text_CADFormatLegend") %></legend>
                                                                        
                                       <asp:PlaceHolder ID="PlaceHolder_BatchGenViews" runat="server">
                                       <fieldset>
                                          <legend><%# ccPublisherWeb.TextDic.TxGet("Text_ccMehrereAnsichtenGenerieren") %></legend>
                                 
                                          <asp:CheckBoxList ID="CBL_BatchGen" CssClass="CBL_BatchGen" AutoPostBack="false" runat="server" RepeatColumns="4" Font-Overline="False" RepeatLayout="Table"></asp:CheckBoxList>
                                             <asp:Panel ID="SectionalViewPanel" Visible="false" CssClass="SectionalView" runat="server">
                                             <div id="SpaceBatchGen"></div>
                                             <asp:CheckBox ID="CB_SectionalView" CssClass="CB_SectionalView" Checked="false" runat="server" />
                                             <asp:LinkButton ID="btnSectionalView" runat="server" OnClientClick="prepareSectionalView();" OnClick="CreateViewerSectionalView">
                                                <div class="SectionalViewViewer_IMG"></div><span class="SectionalViewViewer_SPAN"><%# TextDic.TxGet("Text_SectionalView") %></span>
                                             </asp:LinkButton>
                                          </asp:Panel>
                                       </fieldset>

                                       <div class="FieldsetSpacer"></div>
                                       </asp:PlaceHolder>
                                       <span><%# ccPublisherWeb.TextDic.TxGet("Text_ccCADFormat") %></span>

                                        <select id="outputformat_2d" name="outputformat_2d" onchange="SelectDriverHandler(this, '2D', false);"></select>
                                        <select id="outputoptions_2d" name="outputoptions_2d" style="display:none;"></select>
                                        
                                        <button type="button" id="btncaddownload2d" disabled="disabled" onclick="startDownload(this, null);"><%# TextDic.TxGet("Text_ccDateiGenerieren") %></button>
                                        
                                        <div style="display: none;">
                                            <asp:Button ID="BTN_CAD_DOWNLOAD_2D" runat="server" OnClick="CadDownload_2D" EnableViewState="false" Text="Generieren" />
                                        </div>

                                    </fieldset>
                                 </asp:PlaceHolder>

                                 <asp:PlaceHolder ID="Placeholder_DirectInsert2DEnabled" runat="server">
                                    <div class="FieldsetSpacer"></div>
                        
                                    <fieldset>
                                       <legend><%# ccPublisherWeb.TextDic.TxGet("Text_Click2CADLegend") %></legend>

                                       <table border="0" cellpadding="0" cellspacing="2">
                                          <tr>
                                             <td><span><%#ccPublisherWeb.TextDic.TxGet("Text_ccCADSystem") %></span></td>
                                             <td><asp:Label ID="LBL_C2C2DView" Visible="false" runat="server" /></td>
                                             <td>&nbsp;</td>
                                             <td>&nbsp;</td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <select id="click2cadformat_2d" name="click2cadformat_2d" onchange="SelectDriverHandler(this, '2D', true);"></select>
                                             </td>
                                             <td>
                                                <asp:DropDownList ID="DropDownListC2C2DAnsichten" runat="server"></asp:DropDownList>
                                             </td>
                                             <td>
                                                <button type="button" id="btnclick2cad2d" disabled="disabled" onclick="startDownload(this, null);"><%# TextDic.TxGet("Text_ccClick2CAD") %></button>
                                                <div style="display: none;">
                                                    <asp:Button ID="BTN_CLICK2CAD_2D" runat="server" OnClick="Click2CADInsert_2D" Enabled="false" EnableViewState="false" Text="Click2CAD" />
                                                </div>
                                                <asp:PlaceHolder ID="PH_CLICK2CAD_2D" runat="server"></asp:PlaceHolder>
                                             </td>
                                             <td>
                                                <a href="javascript:;" class="Click2CadHelpButton" onclick="openJavaHelpWindow()" title="<%#ccPublisherWeb.TextDic.TxGet("CADViewer_JavaTest") %>">&nbsp;</a>
                                             </td>
                                            </tr>
                                       </table>
                                        
                                        <div>
                                            <asp:Label ID="LBL_CLICK2CAD_2D" runat="server" ForeColor="red" style="margin-left:3px"></asp:Label>
                                        </div>
                                    </fieldset>
                                 </asp:PlaceHolder>
                              </div>
                           </asp:PlaceHolder>
                  
                           <asp:PlaceHolder ID="Placeholder_TabPanelCAD_DimDraw" runat="server">
                              <div id="TabPanelCAD_DimDraw">
                                 <fieldset>
                                    <legend><%# ccPublisherWeb.TextDic.TxGet("Text_CADFormatLegend") %></legend>
                           
                                    <div class="CADViewerButtons">
                                        <asp:UpdatePanel ID="UpdatePanel_BTN_2D_VIEWER_DIMDRAW" RenderMode="Inline" runat="server" UpdateMode="Conditional">          
                                          <ContentTemplate>
                                             <a class="CADViewerButton_DimDraw" onclick="prepareViewer('2D Viewer'); setTimeout(function() { <%# Page.ClientScript.GetPostBackEventReference(btPostbackDimDraw, "") %> }, 200);"><img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(CADWindow), "ccPublisherWeb.images.dummy.gif") %>" border="0" /></a>

                                             <div style="display: none">
                                                <asp:Button ID="btPostbackDimDraw" OnClick="CreateViewerDimDraw" runat="server" />
                                             </div>
                                          </ContentTemplate>
                                       </asp:UpdatePanel>
                              
                                        <span style="line-height:24px">&nbsp;&nbsp;<%#ccPublisherWeb.TextDic.TxGet("Text_ccCADFormat") %></span>

                                        <select id="outputformat_dimdraw" name="outputformat_dimdraw"></select>
                                             
                                        <asp:Button ID="BTN_CAD_DOWNLOAD_DIMDRAW" runat="server" Enabled="true" OnClick="CadDownloadDimdraw" EnableViewState="false" Text="Generieren" />
                                             
                                        <div style="display: none">
                                            <%-- Hidden postback button for direct PDF creation. See JS-function "startDimDrawPDFExt()" --%>
                                            <asp:Button ID="ButtonDimDrawPDF" runat="server" Enabled="false" OnClick="CadDownloadPdfDimdraw" EnableViewState="false" />
                                        </div>
                                    </div>
                                 </fieldset>
                              </div>
                           </asp:PlaceHolder>

                           <asp:PlaceHolder ID="Placeholder_TabPanelCAD_Attrib" runat="server">
                              <div id="TabPanelCAD_Attrib">
                                 <asp:UpdatePanel ID="Attrib_AP" runat="server" UpdateMode="Conditional"> 
                                    <Triggers>                               
                                       <asp:AsyncPostBackTrigger ControlID="QNA_CHANGED" />
                                    </Triggers>
                                    <ContentTemplate>
                                       <asp:PlaceHolder ID="Attrib_PH_in_UP" runat="server"></asp:PlaceHolder>
                                    </ContentTemplate>
                                 </asp:UpdatePanel>
                              </div>
                           </asp:PlaceHolder>

                           <asp:PlaceHolder ID="Placeholder_TabPanelCAD_PDF3D" runat="server">
                              <div id="TabPanelCAD_PDF3D">
                                   <asp:Table Width="100%" runat="server" GridLines="None" BorderWidth="0" CellPadding="2" CellSpacing="0">
                                       <asp:TableRow>                        
                                           <asp:TableCell>                        
                                               <fieldset>
                                                   <legend><%# ccPublisherWeb.TextDic.TxGet("Text_ccReiterPDF3D") %></legend>
                                                   <table border="0" cellpadding="2" cellspacing="0">
                                                       <tr>
                                                           <td colspan="2">
                                                           <asp:Label ID="Text_3DPDF_Description" runat="server"></asp:Label>                                  
                                                           </td>
                                                       </tr>
                                                       <tr>
                                                           <td colspan="2">
                                                           <asp:Label ID="lbl_3DPDF_Info_FileAttachment_Header" runat="server"></asp:Label>
                                                           </td>
                                                       </tr>
                                                       <tr>
                                                           <td width="15"><asp:CheckBox ID="cbx_3DPDF_FileAttachment_3D" onclick="CheckAttachedCADFormat();" runat="server"></asp:CheckBox></td>
                                                           <td><asp:Label ID="lbl_3DPDF_Info_FileAttachment_3D" runat="server"></asp:Label> [<a id="lk_3DPDF_3D" href="javascript:;" onclick="SetActiveTab('TabPanelCAD_3D')"></a>]</td>
                                                       </tr>
                                                       <tr>
                                                           <td width="15"><asp:CheckBox ID="cbx_3DPDF_FileAttachment_2D" onclick="CheckAttachedCADFormat();" runat="server"></asp:CheckBox></td>
                                                           <td><asp:Label ID="lbl_3DPDF_Info_FileAttachment_2D" runat="server"></asp:Label> [<a id="lk_3DPDF_2D" href="javascript:;" onclick="SetActiveTab('TabPanelCAD_2D')"></a>]</td>
                                                       </tr>
                                                       <tr>
                                                           <td colspan="2">
                                                               <asp:Label ID="lbl_3DPDF_Info_FileAttachment_Footer" runat="server"></asp:Label>
                                                           </td>
                                                       </tr>    
                                                       <tr>                                
                                                           <td colspan="2" align="right">                                    
                                                                <asp:Button ID="BTN_CAD_DOWNLOAD_PDF3DDataSheet" runat="server" Enabled="true" OnClick="CadDownloadPdf3DDataSheet" EnableViewState="false" Text="Generieren" />
                                                           </td>                                                                
                                                       </tr>
                                                   </table>                        
                                               </fieldset>
                                           </asp:TableCell>
                                       </asp:TableRow>                            
                                   </asp:Table>
                              </div>
                           </asp:PlaceHolder>

                           <asp:PlaceHolder ID="Placeholder_TabPanelUserTab0" runat="server">
                               <div id="TabPanelUserTab0">
                                   <asp:UpdatePanel ID="UP_UserTab0" runat="server" UpdateMode="Conditional"> 
                                       <Triggers>
                                           <asp:AsyncPostBackTrigger ControlID="QNA_CHANGED" />
                                       </Triggers>
                                       <ContentTemplate>
                                           <asp:Panel id="TabPanelUserTab0CustomControl" runat="server"></asp:Panel>
                                       </ContentTemplate>
                                   </asp:UpdatePanel>
                               </div>
                           </asp:PlaceHolder>

                        </div>
                     </div>
                 </div>
                </div>
                
                <asp:Panel ID="CustomControlContainer" runat="server"></asp:Panel>

                <div id="QnAPanel">
                    <asp:UpdatePanel ID="UP_QnAAndAttrib" UpdateMode="Conditional" runat="server">
                        <ContentTemplate>
                            <asp:Label ID="L_UP_QNA_DEBUG" runat="server" Visible="true"></asp:Label>            
                  
                            <asp:PlaceHolder ID="HiddenFields_PH" runat="server"></asp:PlaceHolder>

                            <asp:PlaceHolder ID="PH_BOMForm" runat="server"></asp:PlaceHolder>
                            <asp:HiddenField ID="globalValueChanged" Value="" runat="server" EnableViewState="false" />
                            <asp:HiddenField ID="hdCountOfAnswers" Value="" runat="server" EnableViewState="false" />
                            <asp:HiddenField ID="CurrentAnswersList" Value="" runat="server" EnableViewState="false" />
                            <asp:HiddenField ID="changed" Value="" runat="server" EnableViewState="false" />
                            <asp:HiddenField ID="AltWert" Value="" runat="server" EnableViewState="false" />
                            <asp:HiddenField ID="AltEintrag" Value="" runat="server" EnableViewState="false" />
                            <asp:HiddenField ID="storeToggleRubrikVal" Value="" runat="server" EnableViewState="false" />       

                            <ccPublisherWeb:QnATableControl ID="QnaControl" runat="server"></ccPublisherWeb:QnATableControl>

                            <div style="display: none">
                              <asp:Button ID="QNA_CHANGED" OnClick="QnA_Config" runat="server" CssClass="qnachanged" />
                            </div>
                        </ContentTemplate>


                    </asp:UpdatePanel>
                     <asp:PlaceHolder ID="PlaceHolder_ExportJumper" runat="server">
                        <a class="CADViewerButton_Export" onclick="ShowExportPanel()"><span><%# TextDic.TxGet("Text_ccRubrikCADVorschauAusgabe") %></span></a>
                     </asp:PlaceHolder>
               </div>
            </div>
         </div>

         <div class="Dialog_Click2CAD" style="display: <%# (bool)ApplicationVars.Current["DirectInsertInlineMode"] ? "none" : "block" %><%# (bool)ApplicationVars.Current["DirectInsertInlineMode"] ? "" : "; width:0px; height:0px; overflow:hidden" %>">
            <div class="SizeFrame">
               <asp:UpdatePanel ID="UP_CLICK2CAD_APPLET" runat="server" UpdateMode="Conditional">          
                  <Triggers>    
                     <asp:AsyncPostBackTrigger ControlID="BTN_CLICK2CAD_3D" />                       
                     <asp:AsyncPostBackTrigger ControlID="BTN_CLICK2CAD_2D" />                
                  </Triggers>
                  <ContentTemplate>
                     <asp:PlaceHolder ID="PH_CLICK2CAD_APPLET" runat="server"></asp:PlaceHolder>
                     <asp:HiddenField ID="hdClick2CAD_URL" runat="server" />
                  </ContentTemplate>
               </asp:UpdatePanel>
            </div>
         </div>

         <%-- CAD Download --%>        
         <asp:Button runat="server" ID="hiddenTargetControlForModalPopup_CADDownload" style="display:none"/>

         <div class="Popup_CADDownload" style="display: none">
            <div id="DownloadText">
               <asp:UpdatePanel ID="UP_GEN_CAD_DOWNLOADFILE" runat="server" UpdateMode="Conditional">          
                  <Triggers>                               
                     <asp:AsyncPostBackTrigger ControlID="BTN_CAD_DOWNLOAD_3D" />                         
                     <asp:AsyncPostBackTrigger ControlID="BTN_CAD_DOWNLOAD_2D" /> 
                     <asp:AsyncPostBackTrigger ControlID="BTN_CAD_DOWNLOAD_DIMDRAW" /> 
                     <asp:AsyncPostBackTrigger ControlID="ButtonDimDrawPDF" />
                     <asp:AsyncPostBackTrigger ControlID="BTN_CAD_DOWNLOAD_PDF3DDataSheet" /> 
                  </Triggers>
                  <ContentTemplate>
                     <asp:PlaceHolder ID="PH_GEN_CAD_DOWNLOADFILE" runat="server"></asp:PlaceHolder>
                  </ContentTemplate>
               </asp:UpdatePanel>
               <div class="ButtonPanel">
                    <% 
                       if (CommonSettings.SessionSettings.CADBox == CadBoxModes.Disabled && CommonSettings.ApplicationOnlineVersion && StoreFilesToDownloadcenter)
                       {
                           Response.Write("<input id=\"btToDownloadCenter\" style=\"cursor: pointer;\" type=\"button\" value=\"" + ccPublisherWeb.TextDic.TxGet("Text_ToDownloadcenter") + "\" onclick=\"goToDownloadCenter();\" />");
                       } 
                    %>
                    
                    <input id="btDownloadDlgClose" style="cursor: pointer;" type="button" value="<%#ccPublisherWeb.TextDic.TxGet("Text_Schliessen") %>" onclick="$('.Popup_CADDownload').dialog('close')" />
               </div>
            </div>
         </div>
         
         <div class="Dialog_AppletViewer" style="display: none">
            <div class="SizeFrame" style="overflow: hidden">
               <%-- IFRAME will be added upon dialog creation --%>
            </div>
         </div>
         
         <ccPublisherWeb:DisclaimerDialog ID="DisclaimerDialog" runat="server" />
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Error" Visible="false" runat="server">
         <div id="ErrorDiv">
            <ccPublisherWeb:ErrorPanel ID="ErrorPanel" CssClass="ErrorPanel" runat="server" />
         </div>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_CadBoxDL" runat="server">
         <iframe id="CadBoxDL" name="CadBoxDL" src="about:blank" width="0" height="0" frameborder="0" scrolling="no"></iframe>
      </asp:PlaceHolder>

      <div id="DialogOverlay" class="DialogOverlay ModalProgress" style="display:none;position:absolute">
         <table border="0" cellpadding="0" cellspacing="0" width="100%" height="100%" style="width:100%;height:100%">
            <tr>
               <td align="center" valign="middle" style="vertical-align: middle">
                  <%# new TemplateHandler(CommonSettings.CustomerTemplatesFolder + "ModalProgress.txt", TemplateSourceTypes.RelativePath).getResult() %>
               </td>
            </tr>
         </table>
      </div>

      
      <asp:UpdatePanel ID="updHiddenInputs" runat="server" EnableViewState="true" UpdateMode="Conditional">
        <ContentTemplate>
            <asp:HiddenField ID="hidDimDrawMode" Value="" runat="server" EnableViewState="true" />
            <asp:HiddenField ID="hidPipeSessionId" Value="" runat="server" EnableViewState="true" />
            <asp:HiddenField ID="hidCadBoxMode" Value="" runat="server" EnableViewState="true" />
            <asp:HiddenField ID="hidScrollPosition" Value="" runat="server" EnableViewState="true" />

            <asp:HiddenField ID="click2cadvalue" Value="" runat="server" EnableViewState="false" />
            <asp:HiddenField ID="PreviewSize" Value="" runat="server" EnableViewState="false" />
            <asp:HiddenField ID="StartCadPar" Value="" runat="server" EnableViewState="false" />
            
            <asp:HiddenField ID="ccFileType" Value="" runat="server" EnableViewState="false" />
        </ContentTemplate>
      </asp:UpdatePanel>
   </form>

   <asp:PlaceHolder ID="Placeholder_ScriptBottom" runat="server">
      <script language="javascript" type="text/javascript">
          try {
              if(<%# ccPublisherWeb.CommonFunc.JsBool(Placeholder_TabPanelCAD_DimDraw.Visible && HasPdf2D) %>) {
                  parent.Leer.showCADViewerButton_DimDrawPDF(true);
              } else {
                  parent.Leer.showCADViewerButton_DimDrawPDF(false);
              }
          } catch(e) { }
    
          function StartPostBack_QNA() {
              <%# ClientScript.GetPostBackEventReference(QNA_CHANGED, "") %>;       
          } 
      
          function AllowBatchGenCount() {   
              var batchid = "CBL_BatchGen_";
              var selcnt = 0;
              var cntdisabled = 4;   
         
              for(j=0; j<=6; j++) {
                  document.getElementById(batchid + j).disabled = false;    
            
                  if(document.getElementById(batchid + j).checked)
                      selcnt++;
              } 
           
              if(selcnt >= cntdisabled) {
                  for (var i = 0; i <= 6; i++) {  
                      if(!document.getElementById(batchid + i).checked)
                          document.getElementById(batchid +i).disabled = true;
                  }
              }
          }
      
          function SectionalViewSetCheckedToFalse ()
          {
              document.getElementById("<%# CB_SectionalView.ClientID %>").checked = false;
          }
      
          function BatchFileSetCheckedToFalse ()
          {
              var batchid = "CBL_BatchGen_";
              for(j=0; j<=6; j++)
              {
                  document.getElementById(batchid + j).checked = false;    
              } 
          }          

          function js_FormSend(newAction, newTarget, newMethod) {    
              var _theForm = document.getElementById('<%# mainForm.ClientID %>');
              if (!_theForm) {
                  _theForm = document.mainForm;
              }
              if (!_theForm) {
                  alert ('_theForm is null');
              }

              var oldAction = _theForm.action;
              var oldTarget = _theForm.target;
              var oldMethod = _theForm.method;    
              _theForm.action = newAction;
              _theForm.target = newTarget;
              _theForm.method = newMethod;
              _theForm.submit();
              _theForm.action = oldAction;
              _theForm.target = oldTarget;
              _theForm.method = oldMethod;    
          } 

          function getBOMEntryCount() {
              var bomEntryElement = $("#<%# mainForm.ClientID %> #BOMEintraege");

              if(bomEntryElement.length && !isNaN(parseInt(bomEntryElement.val()))) {
                  return parseInt(bomEntryElement.val());
              } else {
                  return 0;
              }
          }

          function Change_ccFileType(ccFileType) {
              if (ccFileType != "") {
                  <%# ModalProgressID %>.Show();
                  $('#<%# ccFileType.ClientID %>').val(ccFileType);
                  $('#<%# globalValueChanged.ClientID %>').val($('#<%# hdCountOfAnswers.ClientID %>').val());
              }
          }

          <asp:PlaceHolder ID="plh_PDF3D_JS" Visible="false" runat="server">
        function getPDF3DFileAttachmentInfo(lbl)
        {
            if (lbl=="2D")
            {
                var ddl2D = document.getElementById('outputformat_2d');
                var ddl2DTxt = ddl2D.options[ddl2D.selectedIndex].text;
                var lbl_3DPDF_Info_FileAttachment_2D_Current_Format=document.getElementById('lk_3DPDF_2D');
                if (null != lbl_3DPDF_Info_FileAttachment_2D_Current_Format)
                    lbl_3DPDF_Info_FileAttachment_2D_Current_Format.innerHTML=ddl2DTxt;
            }
            else if(lbl=="3D")
            {
                var ddl3D = document.getElementById('outputformat_3d');
                var ddl3DTxt = ddl3D.options[ddl3D.selectedIndex].text;
                var lbl_3DPDF_Info_FileAttachment_3D_Current_Format=document.getElementById('lk_3DPDF_3D');
                if (null != lbl_3DPDF_Info_FileAttachment_3D_Current_Format)
                    lbl_3DPDF_Info_FileAttachment_3D_Current_Format.innerHTML=ddl3DTxt;
            } 
            var PDFGen = document.getElementById("<%# BTN_CAD_DOWNLOAD_PDF3DDataSheet.ClientID %>");
            if (null != PDFGen)
                CheckAttachedCADFormat();
        }

        function CheckAttachedCADFormat()
        {   
            var ddl3D = document.getElementById('outputformat_3d');
            var ddl2D = document.getElementById('outputformat_2d');
            var cbx3D = document.getElementById("<%# cbx_3DPDF_FileAttachment_3D.ClientID %>");
            var cbx2D = document.getElementById("<%# cbx_3DPDF_FileAttachment_2D.ClientID %>");
            var btnPDFGen = document.getElementById("<%# BTN_CAD_DOWNLOAD_PDF3DDataSheet.ClientID %>");
            
            var btnPDFGen_disabled = false;        

            if (cbx2D.checked)
            {
                if (0 == ddl2D.selectedIndex)
                    btnPDFGen_disabled = true;
            }
            if (cbx3D.checked)
            {
                if (0 == ddl3D.selectedIndex)
                    btnPDFGen_disabled = true;
            }
            btnPDFGen.disabled = btnPDFGen_disabled;
        }
       </asp:PlaceHolder>


          function MinMaxAlert(AktMin, AktMax) {
              var alertMsg = "<%# Server.HtmlEncode(ccPublisherWeb.TextDic.TxGet("Text_ccMinMaxAlert")).Replace("\r\n", "").Replace("\n", "") %>";

              alertMsg = alertMsg.replace("$AktMin$", AktMin);
              alertMsg = alertMsg.replace("$AktMax$", AktMax);
              alertMsg = alertMsg.replace("$OldEntry$", $("#<%# AltEintrag.ClientID %>").val());
              alertMsg = alertMsg.replace("$OldVal$", $("#<%# AltWert.ClientID %>").val());
            
              <%# MessageBoxID %>.Show({
                  title      : "<%# ccPublisherWeb.TextDic.TxGet("Text_CADWindow_MinMaxAlert_DlgTitle") %>",
                  messageText: alertMsg,
                  width: 400,
                  height: 110,
                  focusButton: MessageBox.Constants.MB_OK,
                  icon: MessageBox.Constants.MB_ICON_WARN,
                  buttons: MessageBox.Constants.MB_OK
              });
          }
      </script>
   
      <ccPublisherWeb:JavascriptRessource ScriptName="js_end_functions.js" runat="server" />

      <script language="javascript" type="text/javascript">
            var json_driverlist = <%# string.IsNullOrEmpty(DriverList) ? "null" : DriverList %>;
            var dimdraw_driverlist = ["BMP", "DWG", "DXF", "GIF", "PDF", "PNG", "TGA", "TIF"];
            var dimdraw_driverlist_min = ["DWG", "DXF", "PDF"];

            var isCADGenMini = <%# CADClick.DimensionalDrawingMode == CADClickDefines.eDimDrawMode.DimDraw_CADGenMini ? "true" : "false" %>;

            var contr_click2cad2d           = '#click2cadformat_2d';
            var contr_click2cad3d           = '#click2cadformat_3d';
            var contr_outputformat2d        = '#outputformat_2d';
            var contr_outputformat3d        = '#outputformat_3d';
            
            var contr_outputoptions2d       = '#outputoptions_2d';
            var contr_outputoptions3d       = '#outputoptions_3d';
            var contr_outputformatdimdraw   = '#outputformat_dimdraw';

            var contr_btngenerate2d         = '#btncaddownload2d';
            var contr_btngenerate3d         = '#btncaddownload3d';
            var contr_btnclick2cad2d        = '#btnclick2cad2d';
            var contr_btnclick2cad3d        = '#btnclick2cad3d';
            
            function FillSelectElement(control, list, isc2c, addheader) {
                if (list == null)
                    return;

                var objSelect = $(control);
                
                if (objSelect.length) {
                    $(objSelect).empty();

                    if (list.length) {
                        if (addheader) {
                            if (isc2c) {
                                objSelect.append(
                                    $('<option></option>').val('-').html('<%# ShowRegistrationHints ? TextDic.TxGet("Text_ccDDLBittePleaseRegister") : TextDic.TxGet("Text_ccDDLBitteWaehlen") %>')
                                );
                            } else {
                                
                                objSelect.append(
                                    $('<option></option>').val('-').html('<%# (RegisterLoginLimit == RegisterLoginLimits.FileCreation && ShowRegistrationHints) ? TextDic.TxGet("Text_ccDDLBittePleaseRegister") : TextDic.TxGet("Text_ccDDLBitteWaehlen") %>')
                                );
                            }
                        }

                        $.each(list, function(index, value) {
                            objSelect.append(
                                $('<option></option>').val(value).html(value)
                            );
                        });

                        objSelect.first().attr("selected", "selected");
                    }
                }
            }//FillSelectElement
            
            <%-- -------------------------------------------------------------------- --%>
            <%-- Function:      ContainsDatasheet                                     --%>
            <%-- Description:   Determines, if the given driverlist contains the      --%>
            <%--                DATASHEET driver.                                     --%>
            <%-- Parameters:                                                          --%>
            <%--    driverlist: The list of format drivers to check.                  --%>
            <%-- -------------------------------------------------------------------- --%>
            function ContainsDatasheet(driverlist) {
                var datasheetfound = false;
                
                $.each(driverlist, function(index, value) {
                    if (value.name == 'DATASHEET') {
                        datasheetfound = true;
                        return false;
                    }

                    return true;
                });

                return datasheetfound;
            }//ContainsDatasheet
            
            <%-- -------------------------------------------------------------------- --%>
            <%-- Function:      PrepareDriverList                                     --%>
            <%-- Description:   Prepares and filters the list of output drivers.      --%>
            <%-- Parameters:                                                          --%>
            <%--    type: Determines, if we prepare the 2D or 3D list.                --%>
            <%-- -------------------------------------------------------------------- --%>
            function PrepareDriverList(type) {
                var list = new Array();

                if (type == null || type == '')
                    return list;

                type = type.toUpperCase();

                var is3D = type == '3D';

                if (json_driverlist != null) {
                    if (json_driverlist.FormatDrivers.length) {
                        var datasheetfound = ContainsDatasheet(json_driverlist.FormatDrivers);

                        $.each(json_driverlist.FormatDrivers, function(index, value) {
                            if (value.Name == 'DATASHEET' || value.Name == 'DIMENSIONALDRAWING')
                                return true;
                            
                            if (value.Name == 'PDF 3D') {
                                if (datasheetfound) {
                                    return true;
                                }
                            }
                            
                            if (value.Driver3D == is3D) { list.push(value.Name); }

                            return true;
                        });

                        if(is3D) list.push("PALETTE CAD");
                        
                        list.sort();
                    }
                }

                return list;
            }//PrepareDriverList
            
            function ToggleControl(controlname, enabled) {
                if (controlname == null || controlname == '')
                    return;

                var control = $(controlname);
                
                if (control.length) {
                    if (enabled) {
                        control.removeAttr("disabled");
                    } else {
                        control.attr("disabled", "disabled");
                    }
                }
            }//ToggleControl
            
            <%-- -------------------------------------------------------------------- --%>
            <%-- Function:      PrepareDriverOptions                                  --%>
            <%-- Description:   Prepares the list of output driver options.           --%>
            <%-- Parameters:                                                          --%>
            <%--    driver: Determines, which drivers options are prepared.           --%>
            <%--    type  : Determines, if we prepare the 2D or 3D list.              --%>
            <%-- -------------------------------------------------------------------- --%>
            function PrepareDriverOptions(driver, type) {
                var list = new Array();
                
                if (driver == null || driver == '')
                    return list;
                
                if (type == null || type == '')
                    return list;

                driver = driver.toUpperCase();
                type = type.toUpperCase();
                
                var is3D = type == '3D';

                if (json_driverlist != null) {
                    if (json_driverlist.FormatDrivers.length) {
                        $.each(json_driverlist.FormatDrivers, function(index, value) {
                            if (value.Name == driver && value.Driver3D == is3D) {
                                list = value.OutputVersions;
                                return false;
                            } else {
                                return true;
                            }
                        });
                    }
                }

                return list;
            }//PrepareDriverOptions
            
            function SelectDriverHandler(obj, type, isc2c) {
                if (obj == null)
                    return;
                
                if (type == null || type == '')
                    return;
                
                type = type.toUpperCase();

                var is3D = type == '3D';

                try {
                    if (!isc2c) getPDF3DFileAttachmentInfo(type);    
                } catch(e) { /* Ignore if function not found. */ } 
                

                if (obj.value == "-") {
                    if (isc2c) {
                        ToggleControl(
                            is3D ? contr_btnclick2cad3d : contr_btnclick2cad2d,
                            false
                        );
                    } else {
                        ToggleControl(
                            is3D ? contr_btngenerate3d : contr_btngenerate2d,
                            false
                        );
                    }
                } else {
                    var list = PrepareDriverOptions(obj.value, type);
                
                    var controlname = is3D ? contr_outputoptions3d : contr_outputoptions2d;
                    var control = $(controlname);
                
                    if (control.length) {
                        if (list.length) {

                            FillSelectElement(controlname, list, false, false);

                            if(!isc2c) control.show();
                        } else {
                            if(!isc2c) control.empty().hide();
                        } 
                    }
                    
                    if (isc2c) {
                        ToggleControl(
                            is3D ? contr_btnclick2cad3d : contr_btnclick2cad2d,
                            true
                        );
                        
                        <%-- Save selected value --%>
                        ccPublisherWeb.SetSessionVariable(
                            is3D ? '<%# CommonDefines.SessionParamClick2CAD3D %>' : '<%# CommonDefines.SessionParamClick2CAD2D %>',
                            obj.value
                        );
                    } else {
                        ToggleControl(
                            is3D ? contr_btngenerate3d : contr_btngenerate2d,
                            true
                        );

                        <%-- Save selected value --%>
                        ccPublisherWeb.SetSessionVariable(
                            is3D ? '<%# CommonDefines.SessionParamFormat3D %>' : '<%# CommonDefines.SessionParamFormat2D %>',
                            obj.value
                        );
                    }
                }

               // Prepared for CAD format option list:
               // IMPORTANT: When enabled ensure to remove the "ccPublisherWeb.SetSessionVariable" call
               // some lines above in the "else" block
               // LoadCadFormatOptions(obj, type);
            }//SelectDriverHandler
            
            function FillDriverControls() {
                if (json_driverlist != null) {
                    FillSelectElement(contr_click2cad2d, json_driverlist.ListClick2CAD2D, true, true);
                    FillSelectElement(contr_click2cad3d, json_driverlist.ListClick2CAD3D, true, true);
                    
                    FillSelectElement(contr_outputformat2d, PrepareDriverList('2D'), false, true);
                    FillSelectElement(contr_outputformat3d, PrepareDriverList('3D'), false, true);

                    <%-- BEGIN: Select last selected values --%>
                    var selected3D = ccPublisherWeb.GetSessionVariable('<%# CommonDefines.SessionParamFormat3D %>');
                    var selected2D = ccPublisherWeb.GetSessionVariable('<%# CommonDefines.SessionParamFormat2D %>');
                    var selectedclick2Cad3D = ccPublisherWeb.GetSessionVariable('<%# CommonDefines.SessionParamClick2CAD3D %>');
                    var selectedclick2Cad2D = ccPublisherWeb.GetSessionVariable('<%# CommonDefines.SessionParamClick2CAD2D %>');


                    if (selected2D != '') {
                        if ($(contr_outputformat2d).length) {
                            $(contr_outputformat2d + ' option').removeAttr('selected');
                            $(contr_outputformat2d + " option[value='" + selected2D + "']").attr('selected', true);

                            SelectDriverHandler($(contr_outputformat2d)[0], '2D', false);
                        }
                    }
                    
                    if (selected3D != '') {
                        if ($(contr_outputformat3d).length) {
                            $(contr_outputformat3d + ' option').removeAttr('selected');
                            $(contr_outputformat3d + " option[value='" + selected3D + "']").attr('selected', true);

                            SelectDriverHandler($(contr_outputformat3d)[0], '3D', false);
                        }
                    }
                    
                    if (selectedclick2Cad2D != '') {
                        if ($(contr_click2cad2d).length) {
                            $(contr_click2cad2d + ' option').removeAttr('selected');
                            $(contr_click2cad2d + " option[value='" + selectedclick2Cad2D + "']").attr('selected', true);

                            SelectDriverHandler($(contr_click2cad2d)[0], '2D', true);
                        }
                    }
                    
                    if (selectedclick2Cad3D != '') {
                        if ($(contr_click2cad3d).length) {
                            $(contr_click2cad3d + ' option').removeAttr('selected');
                            $(contr_click2cad3d + " option[value='" + selectedclick2Cad3D + "']").attr('selected', true);

                            SelectDriverHandler($(contr_click2cad3d)[0], '3D', true);
                        }
                    }
                    <%-- END: Select last selected values --%>

                    if (isCADGenMini) {
                        FillSelectElement(contr_outputformatdimdraw, dimdraw_driverlist, false, false);
                    } else {
                        FillSelectElement(contr_outputformatdimdraw, dimdraw_driverlist_min, false, false);
                    }

                    var linkPdf3Dformat = $('#lk_3DPDF_3D');
                    if (linkPdf3Dformat.length)
                        linkPdf3Dformat.html($(contr_outputformat3d).find(":selected").html());
                    
                    var linkPdf2Dformat = $('#lk_3DPDF_2D');
                    if (linkPdf2Dformat.length)
                        linkPdf2Dformat.html($(contr_outputformat2d).find(":selected").html());
                }
            }//FillDriverControls

            function LoadCadFormatOptions(obj, type) {
               if (obj == null || String.IsNullOrEmpty(type)) {
                    return;
               }

               type = type.toUpperCase();

               var is3D = type == "3D";

               var optionList = is3D ? $("#TabPanelCAD_3D .OptionList .Content") : $("#TabPanelCAD_2D .OptionList .Content");

               optionList.empty();

               if($(obj).val() == "-") {
                  return;
               }

               $$.Callback({
                  url: "<%# ResolveUrl("~/CADWindow.aspx") %>?callback=cadformatoptions",
                  data: {
                     "type": type,
                     "format": $(obj).val()
                  },
                  success: function(result) {
                     if(result.Success) {
                        optionList.html(result.HtmlContent);

                        // Make all labels inside a group the same width
                        optionList.find("FIELDSET").each(function() {
                           var maxLabelWidth = 0;

                           $(this).find("> DIV.value H2").each(function() {
                              maxLabelWidth = Math.max(maxLabelWidth, $(this).outerWidth(true));
                           });

                           $(this).find("> DIV.value H2").width(maxLabelWidth);
                        });

                        optionList.find("INPUT[cftype='color']").each(function() {
                           var self = this;

                           $(self).ColorPicker({
                              color: $(this).val(),
                              onSubmit: function(hsb, hex, rgb, el) {
                                 $(self).val("#" + hex);
                                 $(self).parent(".colorbox").css("background-color", "#" + hex);
                                 $(el).ColorPickerHide();
                              }
                           });
                        });

                        optionList.find("INPUT[cftype='integer']").each(function() {
                           $(this).jStepper({
                              minValue: parseInt($(this).attr("min")),
                              maxValue: parseInt($(this).attr("max"))
                           });
                        });

                        optionList.parent().css("bottom", -optionList.parent().outerHeight() + "px");
                     }
                  }
               });
            }//LoadCadFormatOptions

            function initGUI() {
                FillDriverControls();
            }//initGUI

            function click2CADPreCheckJava() {
                if(javaInstalled()) {
                    setTimeout(function() {
                        <%# Page.ClientScript.GetPostBackEventReference(BTN_CLICK2CAD_3D, "") %>;
                    }, 0);
                } else {
                    openJavaHelpWindow();
                }
            }

            $(document).ready(function() {
                initGUI();
            });
      </script>
   </asp:PlaceHolder>
</body>
</html>
