﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CommonDownloadcenter.aspx.cs" Inherits="ccPublisherWeb.CommonDownloadcenter" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/PageHeader.ascx" TagName="PageHeader" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Software / Updates</title>
   <ccPublisherWeb:CustomerStyleSheet ID="CustomerStyleSheet1" StyleSheetName="DownloadCenter.css" runat="server" />
</head>
<body>
   <form id="form1" runat="server">
      <ccPublisherWeb:PageHeader ID="PageHeader1" CssClass="PageHeader" runat="server" />

      <div id="DownloadCenter" class="CommonDownloadCenter">
         <asp:PlaceHolder ID="Placeholder_Main" runat="server">
            <div class="OuterBorder">
               <asp:PlaceHolder ID="Placeholder_GridView" runat="server">
                  <table id="DownloadTable" class="GridDownload CommonDownloadCenter" border="0" cellpadding="0" cellspacing="0" width="100%">
                     <thead>
                        <tr class="Grid_Header">
                           <th class="Header_Download">&nbsp;</th>
                           <th class="Header_Filename"><%# ccPublisherWeb.TextDic.TxGet("Text_DateiDownload") %></th>
                           <th class="Header_Title"><%# ccPublisherWeb.TextDic.TxGet("Text_DateiTitle") %></th>
                           <th class="Header_Beschreibung"><%# ccPublisherWeb.TextDic.TxGet("Text_Bezeichnung") %></th>
                           <th class="Header_Version"><%# ccPublisherWeb.TextDic.TxGet("Text_Version") %></th>
                           <th class="Header_Date"><%# ccPublisherWeb.TextDic.TxGet("Text_Date") %></th>
                           <th class="Header_FileSize"><%# ccPublisherWeb.TextDic.TxGet("Text_Groesse") %></th>
                        </tr>
                     </thead>

                     <tbody>
                        <asp:Repeater
                           ID="RepeaterDownload"
                           OnItemDataBound="ItemDataBound"
                        
                           runat="server"
                        >
                           <ItemTemplate>
                              <tr class="<%# Eval("RowCssClass") %>">
                                 <td class="Cell_Download">
                                    <a href="<%# Eval("URL") %>"></a>
                                 </td>
                              
                                 <td class="Cell_DownloadFilename">
                                    <a href="<%# Eval("URL") %>">
                                       <%# Eval("DownloadFile")%>
                                    </a>
                                 </td>
       
                                 <td class="Cell_DownloadTitle">
                                       <%# Eval("DownloadTitle") %>
                                 </td>
                                 <td class="Cell_DownloadDescription">
                                    <asp:Literal ID="ctrlLiteralDescription" runat="server">
                                    </asp:Literal>
                                 </td>
                              
                                 <td class="Cell_DownloadVersion">
                                    <%# Eval("DownloadFileVersion") %>
                                 </td>
                              
                                 <td class="Cell_DownloadDate">
                                    <%# Eval("FileDateString")%>
                                 </td>
                                 <td class="Cell_DownloadFileSize">
                                    <%# Eval("FileSizeString") %>
                                 </td>
                              </tr>
                           </ItemTemplate>
                        </asp:Repeater>
                     </tbody>
                  </table>
               </asp:PlaceHolder>

               <script language="javascript" type="text/javascript">
                  function showFileNotFound(url) {
                     <%# MessageBoxID %>.Show({
                        title: "<%# ccPublisherWeb.TextDic.TxGet("Text_DownloadCenter_MsgBox_FileNotFound_Title") %>",
                        messageText: String.format("<%# ccPublisherWeb.TextDic.TxGet("Text_DownloadCenter_MsgBox_FileNotFound_Message") %>", url),
                        width: 400,
                        height: 110,
                        icon: MessageBox.Constants.MB_ICON_ERROR,
                        buttons: MessageBox.Constants.MB_OK
                     });
                  }
               </script>
            </div>
         </asp:PlaceHolder>

         <asp:PlaceHolder ID="Placeholder_NoLoginError" Visible="false" runat="server">
            <div id="ErrorContainer">
               <div class="Header">
                  <span><%# ccPublisherWeb.TextDic.TxGet("Text_CommonDownloadCenter_ErrorHeader") %></span>
               </div>
               <div class="ErrorText">
                  <%# ccPublisherWeb.TextDic.TxGet("Text_CommonDownloadCenter_ErrorText")%>
               </div>
            </div>
         </asp:PlaceHolder>
      </div>
   </form>
</body>
</html>
