﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DisclaimerDialog.ascx.cs" Inherits="ccPublisherWeb.Controls.DisclaimerDialog" %>
<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<script type="text/javascript" language="javascript">
    <%-- Global variable for the target path. --%>
    var downloadtarget = '';
    
    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      showDisclaimerDialog                                  --%>
    <%-- Description:   Displays the disclaimer dialog for the given target   --%>
    <%--                path.                                                 --%>
    <%-- -------------------------------------------------------------------- --%>
    function showDisclaimerDialog(target) {
        showDisclaimerDialog(target, false);
    }//showDisclaimerDialog

    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      showDisclaimerDialog                                  --%>
    <%-- Description:   Displays the disclaimer dialog for the given target   --%>
    <%--                path.                                                 --%>
    <%-- -------------------------------------------------------------------- --%>
    function showDisclaimerDialog(target, multiplefiles) {
        if (target != '') {
        
            downloadtarget = target; 

            $('#DisclaimerDialogFilename').text(getFileName());

            $("#DisclaimerDialog").dialog({
                autoOpen: true,
                modal: true,
                closeOnEscape: true,
                title: '<%# ccPublisherWeb.TextDic.TxGet("DisclaimerDialogTitle") %>',
                width: 450,
                height: 250,
                beforeClose: function() {
                    $('#DisclaimerDialogFilename').text('');

                    if (!multiplefiles) {
                        $('#Dialog_ZipDownload').dialog("close");
                        $('.Popup_CADDownload').dialog("close");
                    }
                },
                resizable: JS_GLOBALS.jqDialogsResizable,
                draggable: JS_GLOBALS.jqDialogsDraggable,
            });
        }
        else
        {
            alert('<%# TextDic.TxGet("DisclaimerDialogErrorNoTarget") %>');
            $('#DisclaimerDialog').dialog('close');
        }
    }//showDisclaimerDialog
    
    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      getFileName                                           --%>
    <%-- Description:   Extracts the filename from the active path.           --%>
    <%-- -------------------------------------------------------------------- --%>
    function getFileName() {
        if (downloadtarget == '') {
            return '<%# TextDic.TxGet("DisclaimerDialogErrorNoTarget") %>';
        }
        
        if (downloadtarget.indexOf('CLICK2CAD') > -1) {
            return '<%# TextDic.TxGet("Text_Click2CADLegend") %>';
        }

        var url;
        if (downloadtarget.toLowerCase().indexOf('binaryfileredirector', 0) == -1) {
            url = downloadtarget;
        } else {
            var startindex;
            var endindex;
            if (downloadtarget.indexOf('TARGET_FILENAME') == -1) {
                startindex = downloadtarget.indexOf('PATH', 0) + 5;
                endindex = downloadtarget.indexOf('&', startindex);

                if (endindex == -1) {
                    url = downloadtarget.slice(startindex, downloadtarget.length);
                } else {
                    url = downloadtarget.slice(startindex, endindex);
                }
            } else {
                startindex = downloadtarget.indexOf('TARGET_FILENAME', 0) + 16;
                endindex = downloadtarget.indexOf('&', startindex);
                
                if (endindex == -1) {
                    url = downloadtarget.slice(startindex, downloadtarget.length);
                } else {
                    url = downloadtarget.slice(startindex, endindex);
                }
            }
        }

        var filename;
        if (url.lastIndexOf('%2f') == -1) {
            filename = url;
        } else {
            filename = url.slice(url.lastIndexOf('%2f') + 3, url.length);
        }
        
        if (filename.lastIndexOf('/') == -1) {
            filename = filename;
        } else {
            filename = filename.slice(filename.lastIndexOf('/') + 1, filename.length);
        }
        
        return filename;
    }//getFileName

    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      startDisclaimerDialogDownload                         --%>
    <%-- Description:   Starts the download.                                  --%>
    <%-- -------------------------------------------------------------------- --%>
    function startDisclaimerDialogDownload() {
        $('#DisclaimerDialog').dialog('close');
        
        switch(downloadtarget) {
            case "CLICK2CAD_2D":
                __doPostBack('BTN_CLICK2CAD_2D');
                break;
            case "CLICK2CAD_3D":
                __doPostBack('BTN_CLICK2CAD_3D');
                break;
            default:
               window.location.assign(downloadtarget);
               break;
        }
    }//startDisclaimerDialogDownload
</script>

<div id="DisclaimerDialog" style="display:none;">
    <div id="DisclaimerDialogContainer">
        <div id="DisclaimerTextbox"><%# TextDic.TxGet("DisclaimerDialogContent") %></div>
        
        <p id="DisclaimerDialogFilename"></p>

        <table width="100%">
            <tr>
                <td align="center"><button type="button" onclick="startDisclaimerDialogDownload();"><%# TextDic.TxGet("DisclaimerDialogDownload")%></button></td>
                <td align="center"><button type="button" onclick="$('#DisclaimerDialog').dialog('close');"><%# TextDic.TxGet("DisclaimerDialogClose")%></button></td>
            </tr>
        </table>
    </div>
</div>