﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RegisterLogin.aspx.cs" Inherits="ccPublisherWeb.RegisterLogin" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
   <title>Register/Login</title>
   
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="RegisterLogin.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="AdminDefault.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="Admin.css" runat="server" />

   <script language="javascript" type="text/javascript">
      function showModal() {
         setTimeout(function() {
            <%# ModalProgressID %>.Show();
         }, 200);
      }


      function showModalOffline() {
         if(<%# ccPublisherWeb.CommonFunc.JsBool(!ccPublisherWeb.CommonSettings.ApplicationOnlineVersion) %>) {
            showModal();
         }
      }
   </script>
</head>
<body>
   <form id="form1" runat="server">
      <div id="LoginPage">
         <asp:PlaceHolder ID="Placeholder_Main" runat="server">
            <div class="DCenter">
               <asp:PlaceHolder ID="Placeholder_LoggedIn" runat="server">
                  <div class="Paragraph">
                     <asp:LinkButton ID="LinkUserLogout" CssClass="LinkUserLogout LinkButton" OnClientClick="showModal()" OnClick="Logout" runat="server"><%# ccPublisherWeb.TextDic.TxGet("Text_Logout") %></asp:LinkButton>
                  </div>
                  <div class="Paragraph">&nbsp;</div>
                  <a id="LinkEditProfile" class="LinkButton" href="RegForm.aspx<%# FormCallExtUrlParam(true) %>" onclick="if(!$(this).hasClass('Disabled')) { showModalOffline(); }"><%# ccPublisherWeb.TextDic.TxGet("Text_ProfilAendern") %></a>
               </asp:PlaceHolder>

               <asp:PlaceHolder ID="Placeholder_NotLoggedIn" runat="server">
                  <div class="Paragraph RegisterInfoText"><%# ccPublisherWeb.TextDic.TxGet("Text_RegisterInfoText") %></div>
            
                  <asp:PlaceHolder ID="Placeholder_Register" runat="server">
                     <a id="LinkRegister" class="LinkButton" href="RegForm.aspx<%# FormCallExtUrlParam(true) %>" onclick="if(!$(this).hasClass('Disabled')) { showModalOffline(); }"><%# ccPublisherWeb.TextDic.TxGet("Text_Registrieren") %></a>
                     <div class="Paragraph">&nbsp;</div>
                  </asp:PlaceHolder>

                  <asp:PlaceHolder ID="Placeholder_TempRegister" runat="server">
                     <a id="LinkTempRegister" class="LinkButton" href="RegForm.aspx?REG_MODE=<%# ccPublisherWeb.RegistrationModes.Temporary %><%# FormCallExtUrlParam(false) %>" onclick="if(!$(this).hasClass('Disabled')) { showModalOffline(); }"><%# ccPublisherWeb.TextDic.TxGet("Text_TempRegister") %></a>
                     <div class="Paragraph">&nbsp;</div>
                  </asp:PlaceHolder>

                  <div class="Paragraph">&nbsp;</div>
            
                  <div class="Paragraph LoginInfoText">
                     <%# ccPublisherWeb.TextDic.TxGet("Text_LoginInfoText") %>
                  </div>
            
                  <div class="Paragraph LoginText">
                     <a id="LinkUserLogin" class="LinkButton" href="UserLogin.aspx<%# FormCallExtUrlParam(true) %>"><%# ccPublisherWeb.TextDic.TxGet("Text_Login") %></a>
                  </div>
       
                  <div class="Paragraph">&nbsp;</div>
                  <div class="Paragraph">&nbsp;</div>
            
                  <a id="LinkRequestPassword" class="LinkButton" href="RequestPassword.aspx<%# FormCallExtUrlParam(true) %>"><%# ccPublisherWeb.TextDic.TxGet("Text_Forgot_your_Password") %></a>
               </asp:PlaceHolder>

               <div id="OnlineCheckMessages" class="OnlineCheckMessages" runat="server">
                  <div id="OnlineCheckProgress" style="display: none"><span><%# ccPublisherWeb.TextDic.TxGet("Text_RegisterLogin_CheckOnlineConnection") %></span></div>
                  <span id="OnlineCheckError" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_RegisterLogin_CheckOnlineConnection_Failed") %></span>
                  <span id="OnlineCheckError_Detail" style="display: none"></span>
                  <span id="OnlineCheckError_ProxyHelp" style="display: none">
                     <%# string.Format(ccPublisherWeb.TextDic.TxGet("Text_RegisterLogin_CheckOnlineConnection_ProxyHelp"), ResolveUrl("~/OfflineSettings.aspx")) %>
                  </span>
               </div>
         
               <div class="Paragraph">&nbsp;</div>
               <div class="Paragraph">&nbsp;</div>
         
               <div id="Text_FragenUmgang">
                  <%# ccPublisherWeb.TextDic.TxGet("Text_FragenUmgang") %>
               </div>
         
               <div id="Footer">
                  <%# ccPublisherWeb.TextDic.TxGet("Text_Copy_Rechte") %>
               </div>
            </div>
         </asp:PlaceHolder>

         <asp:PlaceHolder ID="Placeholder_Maintenance" Visible="false" runat="server">
            <div class="MaintenanceMode">
               <%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_DisabledMaintenance")%>
            </div>
         </asp:PlaceHolder>
      </div>

      <script language="javascript" type="text/javascript">
         <asp:PlaceHolder ID="Placeholder_OnlineCheckScript" runat="server">
            function checkOnlineConnection() {
               $.ajax({
                  url: "RegisterLogin.aspx?CheckOnline=1",
                  success: function(msg) {
                     if(msg != "undefined") {
                        if(msg == "1") {
                           $("#OnlineCheckProgress").hide();

                           $(".LinkButton").toggleClass("Disabled", false);
                           $(".LinkButton").each(function() {
                              $(this).attr("href", $(this).attr("tmphref"));
                           });
                           $(".LinkButton").removeAttr("tmphref").removeAttr("tmponclick");
                        } else {
                           $("#OnlineCheckProgress").hide();
                           $("#OnlineCheckError").show();
                           $("#OnlineCheckError_Detail").show();
                           $("#OnlineCheckError_Detail").html(msg);
                           $("#OnlineCheckError_ProxyHelp").show();
                        }
                     } else {
                        $("#OnlineCheckProgress").hide();
                        $("#OnlineCheckError").show();
                        $("#OnlineCheckError_Detail").hide();
                        $("#OnlineCheckError_ProxyHelp").show();
                     }
                  },
                  error: function(jqXHR, textStatus, errorThrown) {
                     $("#OnlineCheckProgress").hide();
                     $("#OnlineCheckError").show();
                     $("#OnlineCheckError_Detail").show();
                     $("#OnlineCheckError_Detail").html(textStatus + " " + jqXHR.status);
                     $("#OnlineCheckError_ProxyHelp").show();
                  }   
               });
            }

            $(function() {
               $("#OnlineCheckProgress").show();
               $(".LinkButton").toggleClass("Disabled", true);
               $(".LinkButton").each(function() {
                  $(this).attr("tmphref", $(this).attr("href"))
                  $(this).attr("href", "javascript:;");
               });

               if($("#<%# OnlineCheckMessages.ClientID %>").length) {
                  checkOnlineConnection();
               }
            });
         </asp:PlaceHolder>

         <asp:PlaceHolder ID="Placeholder_CheckTopFrameLoginScript" runat="server">
            <%-- If there is no user logged-in on page-call, also check if the top frame (RegistrationState.ascx) --%>
            <%-- still has the login state. In this case reload the frame --%>
            if(parent && parent.title && typeof(parent.title.isUserLogin) != "undefined") {
               if(parent.title.isUserLogin != "") {
                  parent.title.location.href = parent.title.location.href;
               }
            }
         </asp:PlaceHolder>
      </script>
   </form>
</body>
</html>
