﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ZipProgressBar.aspx.cs" Inherits="ccPublisherWeb.ZipProgressBar" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="cc" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
   <title></title>
   
   <cc:CustomerStyleSheet StyleSheetName="DownloadProgress.css" runat="server" />
   
   <asp:Placeholder ID="Placeholder_ModifyReferrer" runat="server">
        <script language="javascript" type="text/javascript" src="js-xsa-snippet.js"></script>
    </asp:Placeholder>
</head>
<body>
   <form id="form1" runat="server">
      <asp:PlaceHolder ID="Placeholder_Main" Visible="false" runat="server">
         <table class="Layout" border="0" cellpadding="0" cellspacing="0">
            <tr>
               <td align="center" valign="middle">
                  <div id="Placeholder_ProgressBar">
                     <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                           <td align="left">
                              <%# txDownloadCreating %>
                              <br /><br />
                           </td>
                        </tr>
                        <tr>
                           <td align="center">
                              <div class="ProgressBar">
                                 <span id="lbProgress" class="Label"></span>
                                 <div id="progressBarFinished" class="Finished" style="width:100%"></div>
                              </div>
                           </td>
                        </tr>
                        <tr>
                           <td><br /></td>
                        </tr>
                        <tr>
                           <td align="center">
                              <input type="button" class="CancelButton" value="<%# ccPublisherWeb.TextDic.TxGet("Text_Abbrechen") %>" onclick="abortZip()" />
                           </td>
                        </tr>
                     </table>
                  </div>
            
                  <div id="Placeholder_DownloadLink" style="display: none">
                     <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                           <td align="left">
                              <a ID="lkDownload" class="ZipButton" runat="server">
                                 <img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(CADWindow), "ccPublisherWeb.images.dummy.gif") %>" border="0" align="absmiddle" />
                                 <span><%# ccPublisherWeb.TextDic.TxGet("Text_DateiHerunterladen") %></span>
                              </a>&nbsp;<span id="lbDownloadSize"></span>
                           </td>
                        </tr>
                        <tr>
                           <td><br /><br /></td>
                        </tr>
                        <tr>
                           <td align="center">
                              <input type="button" class="CancelButton" value="<%# ccPublisherWeb.TextDic.TxGet("Text_Schliessen") %>" onclick="parent.abortZip()" />
                           </td>
                        </tr>
                     </table>
                  </div>
               
                  <div id="Placeholder_MailSentOK" style="display: none">
                     <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                           <td align="center">
                              <%# String.Format(ccPublisherWeb.TextDic.TxGet("Text_EmailSuccessfulSent"), ZipThreadResults.Current[new Guid(Request["RequestID"])].EmailAddress)%>
                           </td>
                        </tr>
                        <tr>
                           <td><br /></td>
                        </tr>
                        <tr>
                           <td align="center">
                              <input type="button" class="CancelButton" value="<%# ccPublisherWeb.TextDic.TxGet("Text_Schliessen") %>" onclick="parent.abortZip()" />
                           </td>
                        </tr>
                     </table>
                  </div>
               
                  <div id="Placeholder_Error" style="display: none">
                     <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                           <td align="center">
                              <fieldset class="ErrorPanel">
                                 <legend>Error</legend>
                                 <div>
                                    <span id="lbErrorText" />
                                 </div>
                              </fieldset>
                           </td>
                        </tr>
                        <tr>
                           <td align="center">
                              <input type="button" class="CancelButton" value="<%# ccPublisherWeb.TextDic.TxGet("Text_Schliessen") %>" onclick="parent.abortZip()" />
                           </td>
                        </tr>
                     </table>
                  </div>
               </td>
            </tr>
         </table>
    
         <script language="javascript" type="text/javascript">
            var cancelZip = false;
   
            function updateStatus() {
               var pgUrl = "";
         
               if(!cancelZip) {
                  pgUrl = "ZipProgressHandler.ashx?GUID=<%# Request["RequestID"] %>";
               } else {
                  pgUrl = "ZipProgressHandler.ashx?GUID=<%# Request["RequestID"] %>&CANCEL=1";
               }
            
               $.ajax({
                  url: pgUrl,
                  success: callbackResponse,
                  cache: false,
                  dataType: "text"
               });
            }
      
         
            function callbackResponse(response) {
               // The result must contain the name of the progress handler.
               // If not a compile error or other unhandled error occured.
               // In this case display a alert box with the response (error) text.
               if(response.indexOf("<%# typeof(ccPublisherWeb.ZipProgressHandler).Name %>") == 0) {
                  var mode  = response.split("|")[1];
                  var value = response.split("|")[2];

                  switch(mode) {
                     case "<%# ccPublisherWeb.ZipProgressStatus.Initialize.ToString() %>":
                        setTimeout(function() {
                           updateStatus();
                        }, 500);
                        break;
                  
                     case "<%# ccPublisherWeb.ZipProgressStatus.InProgress.ToString() %>":
                        showView("Placeholder_ProgressBar");
                        var percent = parseInt(value);

                        if(percent >= 0 && percent <= 100) {
                           $("#progressBarFinished").css("width", (100 - percent).toString() + "%");
                           $("#lbProgress").html(percent.toString() + "%");
                        }
               
                        setTimeout(function() {
                           updateStatus();
                        }, 500);
                        break;
                  
                     case "<%# ccPublisherWeb.ZipProgressStatus.Finished.ToString() %>":
                        $("#lbDownloadSize").html(String.format("<%# ccPublisherWeb.TextDic.TxGet("Text_DownloadGroesse") %>", value));
                        showView("Placeholder_DownloadLink");
                        break;

                     case "<%# ccPublisherWeb.ZipProgressStatus.MailSentOK.ToString() %>":
                        showView("Placeholder_MailSentOK");
                        break;
                  
                     case "<%# ccPublisherWeb.ZipProgressStatus.Error.ToString() %>":
                        showView("Placeholder_Error");
                        $("#lbErrorText").html(value);
                        break;
                  
                     case "<%# ccPublisherWeb.ZipProgressStatus.Cancel.ToString() %>":
                        parent.abortZip();
                        break;
                  }
               } else {
                  alert("ZIP progress error: " + response);
               }
            }
      
      
            function showView(viewID) {
               $("#Placeholder_ProgressBar").css("display", (viewID == "Placeholder_ProgressBar" ? "block" : "none"));
               $("#Placeholder_DownloadLink").css("display", (viewID == "Placeholder_DownloadLink" ? "block" : "none"));
               $("#Placeholder_MailSentOK").css("display", (viewID == "Placeholder_MailSentOK" ? "block" : "none"));
               $("#Placeholder_Error").css("display", (viewID == "Placeholder_Error" ? "block" : "none"));
            }
      
      
            function abortZip() {
               cancelZip = true;
            }


            $(function() {
               updateStatus();
            });
         </script>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Error" Visible="false" runat="server">
         <span style="color: red"><asp:Literal ID="txErrorText" runat="server" /></span>
      </asp:PlaceHolder>
   </form>
</body>
</html>
